/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import gnu.java.nio.ChannelReader;
import gnu.java.nio.InputStreamChannel;
import gnu.java.nio.OutputStreamChannel;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.VMChannels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public final class Channels {
    public static final InputStream newInputStream(ReadableByteChannel readableByteChannel) {
        return VMChannels.newInputStream(readableByteChannel);
    }

    public static final OutputStream newOutputStream(WritableByteChannel writableByteChannel) {
        return VMChannels.newOutputStream(writableByteChannel);
    }

    public static final ReadableByteChannel newChannel(InputStream inputStream) {
        return new InputStreamChannel(inputStream);
    }

    public static final WritableByteChannel newChannel(OutputStream outputStream) {
        return new OutputStreamChannel(outputStream);
    }

    public static final Reader newReader(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        return new ChannelReader(readableByteChannel, charsetDecoder, n);
    }

    public static final Reader newReader(ReadableByteChannel readableByteChannel, String string) {
        return Channels.newReader(readableByteChannel, Charset.forName(string).newDecoder(), -1);
    }

    public static final Writer newWriter(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        throw new Error("not implemented");
    }

    public static final Writer newWriter(WritableByteChannel writableByteChannel, String string) {
        return Channels.newWriter(writableByteChannel, Charset.forName(string).newEncoder(), -1);
    }

    private Channels() {
    }
}

