/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import gnu.classpath.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;
    static /* synthetic */ Class class$javax$sound$sampled$spi$AudioFileReader;
    static /* synthetic */ Class class$javax$sound$sampled$spi$AudioFileWriter;
    static /* synthetic */ Class class$javax$sound$sampled$spi$FormatConversionProvider;
    static /* synthetic */ Class class$javax$sound$sampled$spi$MixerProvider;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        Class clazz = class$javax$sound$sampled$spi$AudioFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileReader = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioFileFormat(file);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("file type not recognized");
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Class clazz = class$javax$sound$sampled$spi$AudioFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileReader = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioFileFormat(inputStream);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("input stream type not recognized");
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        Class clazz = class$javax$sound$sampled$spi$AudioFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileReader = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioFileFormat(uRL);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("URL type not recognized");
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        HashSet hashSet = new HashSet();
        Class clazz = class$javax$sound$sampled$spi$AudioFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileWriter = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes();
            int n = 0;
            while (n < typeArray.length) {
                hashSet.add(typeArray[n]);
                ++n;
            }
        }
        return (AudioFileFormat.Type[])hashSet.toArray(new AudioFileFormat.Type[hashSet.size()]);
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        HashSet hashSet = new HashSet();
        Class clazz = class$javax$sound$sampled$spi$AudioFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileWriter = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes(audioInputStream);
            int n = 0;
            while (n < typeArray.length) {
                hashSet.add(typeArray[n]);
                ++n;
            }
        }
        return (AudioFileFormat.Type[])hashSet.toArray(new AudioFileFormat.Type[hashSet.size()]);
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        HashSet hashSet = new HashSet();
        Class clazz = class$javax$sound$sampled$spi$FormatConversionProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$FormatConversionProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.FormatConversionProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isConversionSupported(encoding, audioInputStream.getFormat())) continue;
            return formatConversionProvider.getAudioInputStream(encoding, audioInputStream);
        }
        throw new IllegalArgumentException("encoding not supported for stream");
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        HashSet hashSet = new HashSet();
        Class clazz = class$javax$sound$sampled$spi$FormatConversionProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$FormatConversionProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.FormatConversionProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isConversionSupported(audioFormat, audioInputStream.getFormat())) continue;
            return formatConversionProvider.getAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("format not supported for stream");
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        Class clazz = class$javax$sound$sampled$spi$AudioFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileReader = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioInputStream(file);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("file type not recognized");
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Class clazz = class$javax$sound$sampled$spi$AudioFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileReader = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioInputStream(inputStream);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("input stream type not recognized");
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        Class clazz = class$javax$sound$sampled$spi$AudioFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileReader = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileReader;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileReader audioFileReader = (AudioFileReader)iterator.next();
            try {
                return audioFileReader.getAudioInputStream(uRL);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        }
        throw new UnsupportedAudioFileException("URL type not recognized");
    }

    public static Clip getClip() throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            Line[] lineArray = mixer.getSourceLines();
            int n2 = 0;
            while (n2 < lineArray.length) {
                if (lineArray[n2] instanceof Clip) {
                    return (Clip)lineArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Clip getClip(Mixer.Info info) throws LineUnavailableException {
        Mixer mixer = AudioSystem.getMixer(info);
        Line[] lineArray = mixer.getSourceLines();
        int n = 0;
        while (n < lineArray.length) {
            if (lineArray[n] instanceof Clip) {
                return (Clip)lineArray[n];
            }
            ++n;
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            try {
                return mixer.getLine(info);
            }
            catch (LineUnavailableException lineUnavailableException) {
                ++n;
            }
        }
        throw new LineUnavailableException("no Clip available");
    }

    public static Mixer getMixer(Mixer.Info info) {
        Class clazz = class$javax$sound$sampled$spi$MixerProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$MixerProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.MixerProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MixerProvider mixerProvider = (MixerProvider)iterator.next();
            if (!mixerProvider.isMixerSupported(info)) continue;
            return mixerProvider.getMixer(info);
        }
        throw new IllegalArgumentException("mixer not found");
    }

    public static Mixer.Info[] getMixerInfo() {
        HashSet hashSet = new HashSet();
        Class clazz = class$javax$sound$sampled$spi$MixerProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$MixerProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.MixerProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            MixerProvider mixerProvider = (MixerProvider)iterator.next();
            Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
            int n = 0;
            while (n < infoArray.length) {
                hashSet.add(infoArray[n]);
                ++n;
            }
        }
        return (Mixer.Info[])hashSet.toArray(new Mixer.Info[hashSet.size()]);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        Class clazz = class$javax$sound$sampled$SourceDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$SourceDataLine = AudioSystem.class("[Ljavax.sound.sampled.SourceDataLine;", false);
        }
        DataLine.Info info = new DataLine.Info(clazz, audioFormat);
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            if (mixer.isLineSupported(info)) {
                return (SourceDataLine)mixer.getLine(info);
            }
            ++n;
        }
        throw new LineUnavailableException("source data line not found");
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat, Mixer.Info info) throws LineUnavailableException {
        Class clazz = class$javax$sound$sampled$SourceDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$SourceDataLine = AudioSystem.class("[Ljavax.sound.sampled.SourceDataLine;", false);
        }
        DataLine.Info info2 = new DataLine.Info(clazz, audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        if (mixer.isLineSupported(info2)) {
            return (SourceDataLine)mixer.getLine(info2);
        }
        throw new LineUnavailableException("source data line not found");
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        HashSet hashSet = new HashSet();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo(info);
            int n2 = 0;
            while (n2 < infoArray2.length) {
                hashSet.add(infoArray2[n2]);
                ++n2;
            }
            ++n;
        }
        return (Line.Info[])hashSet.toArray(new Line.Info[hashSet.size()]);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        Class clazz = class$javax$sound$sampled$TargetDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$TargetDataLine = AudioSystem.class("[Ljavax.sound.sampled.TargetDataLine;", false);
        }
        DataLine.Info info = new DataLine.Info(clazz, audioFormat);
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            if (mixer.isLineSupported(info)) {
                return (TargetDataLine)mixer.getLine(info);
            }
            ++n;
        }
        throw new LineUnavailableException("target data line not found");
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat, Mixer.Info info) throws LineUnavailableException {
        Class clazz = class$javax$sound$sampled$TargetDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$TargetDataLine = AudioSystem.class("[Ljavax.sound.sampled.TargetDataLine;", false);
        }
        DataLine.Info info2 = new DataLine.Info(clazz, audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        if (mixer.isLineSupported(info2)) {
            return (TargetDataLine)mixer.getLine(info2);
        }
        throw new LineUnavailableException("target data line not found");
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        HashSet hashSet = new HashSet();
        Class clazz = class$javax$sound$sampled$spi$FormatConversionProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$FormatConversionProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.FormatConversionProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isSourceEncodingSupported(encoding)) continue;
            AudioFormat.Encoding[] encodingArray = formatConversionProvider.getTargetEncodings();
            int n = 0;
            while (n < encodingArray.length) {
                hashSet.add(encodingArray[n]);
                ++n;
            }
        }
        return (AudioFormat.Encoding[])hashSet.toArray(new AudioFormat.Encoding[hashSet.size()]);
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        HashSet hashSet = new HashSet();
        Class clazz = class$javax$sound$sampled$spi$FormatConversionProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$FormatConversionProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.FormatConversionProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            AudioFormat.Encoding[] encodingArray = formatConversionProvider.getTargetEncodings(audioFormat);
            int n = 0;
            while (n < encodingArray.length) {
                hashSet.add(encodingArray[n]);
                ++n;
            }
        }
        return (AudioFormat.Encoding[])hashSet.toArray(new AudioFormat.Encoding[hashSet.size()]);
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        HashSet hashSet = new HashSet();
        Class clazz = class$javax$sound$sampled$spi$FormatConversionProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$FormatConversionProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.FormatConversionProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            AudioFormat[] audioFormatArray = formatConversionProvider.getTargetFormats(encoding, audioFormat);
            int n = 0;
            while (n < audioFormatArray.length) {
                hashSet.add(audioFormatArray[n]);
                ++n;
            }
        }
        return (AudioFormat[])hashSet.toArray(new AudioFormat[hashSet.size()]);
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        HashSet hashSet = new HashSet();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo(info);
            int n2 = 0;
            while (n2 < infoArray2.length) {
                hashSet.add(infoArray2[n2]);
                ++n2;
            }
            ++n;
        }
        return (Line.Info[])hashSet.toArray(new Line.Info[hashSet.size()]);
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        Class clazz = class$javax$sound$sampled$spi$FormatConversionProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$FormatConversionProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.FormatConversionProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isConversionSupported(encoding, audioFormat)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        Class clazz = class$javax$sound$sampled$spi$FormatConversionProvider;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$FormatConversionProvider = AudioSystem.class("[Ljavax.sound.sampled.spi.FormatConversionProvider;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)iterator.next();
            if (!formatConversionProvider.isConversionSupported(audioFormat, audioFormat2)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isFileTypeSupported(AudioFileFormat.Type[] typeArray, AudioFileFormat.Type type) {
        int n = 0;
        while (n < typeArray.length) {
            if (typeArray[n].equals(type)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        return AudioSystem.isFileTypeSupported(AudioSystem.getAudioFileTypes(), type);
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        return AudioSystem.isFileTypeSupported(AudioSystem.getAudioFileTypes(audioInputStream), type);
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        while (n < infoArray.length) {
            if (AudioSystem.getMixer(infoArray[n]).isLineSupported(info)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        Class clazz = class$javax$sound$sampled$spi$AudioFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileWriter = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            if (!audioFileWriter.isFileTypeSupported(type, audioInputStream)) continue;
            return audioFileWriter.write(audioInputStream, type, file);
        }
        throw new IllegalArgumentException("file type not supported by system");
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        Class clazz = class$javax$sound$sampled$spi$AudioFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$spi$AudioFileWriter = AudioSystem.class("[Ljavax.sound.sampled.spi.AudioFileWriter;", false);
        }
        Iterator iterator = ServiceFactory.lookupProviders(clazz);
        while (iterator.hasNext()) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)iterator.next();
            if (!audioFileWriter.isFileTypeSupported(type, audioInputStream)) continue;
            return audioFileWriter.write(audioInputStream, type, outputStream);
        }
        throw new IllegalArgumentException("file type not supported by system");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private AudioSystem() {
    }
}

