/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.apache.log4j.Logger;

public class MemoryCleaner {
    private static final Logger LOG = Logger.getLogger(MemoryCleaner.class);

    public static void clean(Object object) {
        Class<?> clazz = object.getClass();
        LOG.debug((Object)("Cleaning up object of type: " + clazz.getName()));
        try {
            Field[] fieldArray = clazz.getMethod("dispose", new Class[0]);
            fieldArray.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            LOG.info((Object)"Cleaning up collection elements");
            for (Object e : (Collection)object) {
                MemoryCleaner.clean(e);
            }
        }
        for (Field field : clazz.getFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            try {
                LOG.info((Object)("Cleaning up field: " + field.getName()));
                Object object2 = field.get(object);
                field.set(object, null);
                MemoryCleaner.clean(object2);
            }
            catch (Exception exception) {
                LOG.error((Object)exception);
            }
        }
    }
}

