/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.hash.IMessageDigest;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class DigestInputStream
extends FilterInputStream {
    private IMessageDigest md5;
    private IMessageDigest sha;
    private boolean digesting;

    final void setDigesting(boolean bl) {
        this.digesting = bl;
    }

    public final int read() throws IOException {
        int n = this.in.read();
        if (this.digesting && n != -1) {
            this.md5.update((byte)n);
            this.sha.update((byte)n);
        }
        return n;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (this.digesting && n3 != -1) {
            this.md5.update(byArray, n, n3);
            this.sha.update(byArray, n, n3);
        }
        return n3;
    }

    DigestInputStream(InputStream inputStream, IMessageDigest iMessageDigest, IMessageDigest iMessageDigest2) {
        super(inputStream);
        if (iMessageDigest == null || iMessageDigest2 == null) {
            throw new NullPointerException();
        }
        this.md5 = iMessageDigest;
        this.sha = iMessageDigest2;
        this.digesting = true;
    }
}

