/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Graphics2D;
import java.util.AbstractCollection;
import java.util.ArrayList;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.SceneGraphBase;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;

public abstract class CompositeBase
extends SceneGraphBase
implements CompositeNode {
    private ArrayList _nodes = new ArrayList();
    private transient ArrayList _last_drawn_nodes = new ArrayList();

    protected CompositeBase() {
    }

    public int getSubgraphCount() {
        return this._nodes.size();
    }

    public SceneGraph getSubgraph(int n) {
        return (SceneGraph)this._nodes.get(n);
    }

    public int getVisibleSubgraphCount() {
        return this.getSubgraphCount();
    }

    public SceneGraph getVisibleSubgraph(int n) {
        return this.getSubgraph(n);
    }

    public int getLastDrawnSubgraphCount() {
        return this._last_drawn_nodes.size();
    }

    public SceneGraph getLastDrawnSubgraph(int n) {
        return (SceneGraph)this._last_drawn_nodes.get(n);
    }

    public void accept(SceneGraphProcessor sceneGraphProcessor) {
        sceneGraphProcessor.process(this);
    }

    public void addSubgraph(SceneGraph sceneGraph) {
        this._nodes.add(sceneGraph);
        this.setDirty(true);
    }

    public void removeSubgraph(SceneGraph sceneGraph) {
        ((AbstractCollection)this._nodes).remove(sceneGraph);
        this.setDirty(true);
    }

    public void removeSubgraph(int n) {
        this._nodes.remove(n);
        this.setDirty(true);
    }

    public void draw(Graphics2D graphics2D) {
        this._last_drawn_nodes.clear();
        int n = this.getVisibleSubgraphCount() - 1;
        while (n >= 0) {
            SceneGraph sceneGraph = this.getVisibleSubgraph(n);
            sceneGraph.draw(graphics2D);
            this._last_drawn_nodes.add(sceneGraph);
            --n;
        }
        this.setDirty(false);
    }
}

