/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.salt;

import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.salt.SaltGenerator;

public final class FixedStringSaltGenerator
implements SaltGenerator {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String salt = null;
    private String charset = "UTF-8";
    private byte[] saltBytes = null;

    public synchronized void setSalt(String salt) {
        Validate.notNull((Object)salt, (String)"Salt cannot be set null");
        this.salt = salt;
    }

    public synchronized void setCharset(String charset) {
        Validate.notNull((Object)charset, (String)"Charset cannot be set null");
        this.charset = charset;
    }

    public byte[] generateSalt(int lengthBytes) {
        if (this.salt == null) {
            throw new EncryptionInitializationException("Salt has not been set");
        }
        if (this.saltBytes == null) {
            try {
                this.saltBytes = this.salt.getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new EncryptionInitializationException("Invalid charset specified: " + this.charset);
            }
        }
        if (this.saltBytes.length < lengthBytes) {
            throw new EncryptionInitializationException("Requested salt larger than set");
        }
        return ArrayUtils.subarray((byte[])this.saltBytes, (int)0, (int)lengthBytes);
    }

    public boolean includePlainSaltInEncryptionResults() {
        return false;
    }
}

