/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.miscutils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ComponentNote
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static int MARGIN = 4;
    private JComponent mainComponent;

    public ComponentNote(Icon icon, String text, JComponent mainComponent) {
        super(new BorderLayout());
        this.mainComponent = mainComponent;
        JLabel label = new JLabel(text);
        if (icon != null) {
            label.setIcon(icon);
        }
        this.add((Component)label, "Center");
        JLabel closeLabel = new JLabel("X");
        closeLabel.setBorder(BorderFactory.createEmptyBorder(0, MARGIN, 0, 0));
        this.add((Component)closeLabel, "East");
        closeLabel.setCursor(Cursor.getPredefinedCursor(12));
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ComponentNote.this.setVisible(false);
            }
        });
        this.setOpaque(true);
        this.setBackground(Color.orange);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(MARGIN, MARGIN, MARGIN, MARGIN)));
        mainComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                ComponentNote.this.updateLocation();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ComponentNote.this.updateLocation();
            }
        });
        mainComponent.getParent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ComponentNote.this.updateLocation();
            }
        });
        this.updateLocation();
    }

    private void updateLocation() {
        Rectangle mainBounds = SwingUtilities.convertRectangle(this.mainComponent.getParent(), this.mainComponent.getBounds(), null);
        Rectangle rootBounds = SwingUtilities.getRoot(this.mainComponent).getBounds();
        Dimension bounds = this.getPreferredSize();
        int x = mainBounds.x + (mainBounds.width - bounds.width) / 2;
        if (x + bounds.width > rootBounds.width) {
            x -= x + bounds.width - rootBounds.width + 2 * MARGIN;
        }
        int y = mainBounds.y - bounds.height - mainBounds.height - 2 * MARGIN;
        this.setBounds(new Rectangle(x, y, bounds.width, bounds.height));
    }
}

