#    Jools -- a graphical puzzle game in the Tetris tradition
#    
#    Copyright (C) 2002-2003 Paul Pelzl
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# Global variables.

VERSION = "0.20"

GRAVITY  = 0.8   # Acceleration of gravity

SCREENW  = 640 
SCREENH  = 480
JOOLSIZE = 45    # pixel width of a jool

#READ_INPUT_DELAY = 15      # standard delay while waiting for button click
READ_INPUT_DELAY = 1      # standard delay while waiting for button click

FALLING_TARGET_FPS  = 30   # target FPS during jool falling animation
ROTATING_TARGET_FPS = 32   # target FPS during jool rotation animation
SWAPPING_TARGET_FPS = 40   # target FPS during jool swapping animation

UPDATEALL      = 0
UPDATEROTATION = 1
UPDATESWAPS    = 2
UPDATEFALLING  = 3
UPDATEREDRAW   = 4

MAXTIME = 1000            # timer maximum value


#TIMER_DECREMENT = 0.5
#TIMER_DECREMENT_MOD = 0.4
# Make the timer rate independent of the FPS
TIMER_DECREMENT = 0.5*30.0 / float (ROTATING_TARGET_FPS)        # initial amount the timer is decremented by per frame
TIMER_DECREMENT_MOD = 0.4*30.0 / float(ROTATING_TARGET_FPS)     # amount by which timer decrement changes per level

JOOLS_PER_LEVEL = 200     # number of jools to reach a new level


# base audio volumes
TITLE_BASE_VOL   = 0.5
TIMED_BASE_VOL   = 0.5
UNTIMED_BASE_VOL = 0.5

DEFAULT_SOUND_SET = 1
SOUND_SET_MAX     = 1

POINT1_00_BASE_VOL  = 0.50
POINT2_00_BASE_VOL  = 0.50
POINT3_00_BASE_VOL  = 0.50
POINT4_00_BASE_VOL  = 0.50
POINT5_00_BASE_VOL  = 0.50
POINT6_00_BASE_VOL  = 0.50
CLICK_00_BASE_VOL   = 0.03
BUZZ_00_BASE_VOL    = 0.25
LEVELUP_00_BASE_VOL = 0.50

POINT1_01_BASE_VOL  = 0.50
POINT2_01_BASE_VOL  = 0.50
POINT3_01_BASE_VOL  = 0.50
POINT4_01_BASE_VOL  = 0.50
POINT5_01_BASE_VOL  = 0.50
POINT6_01_BASE_VOL  = 0.50
CLICK_01_BASE_VOL   = 0.03
BUZZ_01_BASE_VOL    = 0.25
LEVELUP_01_BASE_VOL = 0.50


# arch-tag: global variables

