require 'mkmf'
require 'rbconfig'
require 'fileutils'

ZK_DEBUG = (ENV['DEBUG'] or ARGV.any? { |arg| arg == '--debug' })
ZK_DEV = ENV['ZK_DEV']
DEBUG_CFLAGS = " -O0 -ggdb3 -DHAVE_DEBUG -fstack-protector-all"

if ZK_DEBUG
  $stderr.puts "*** Setting debug flags. ***"
  $EXTRA_CONF = "#{$EXTRA_CONF} --enable-debug"
  $CFLAGS.gsub!(/ -O[^0] /, ' ')
  $CFLAGS << DEBUG_CFLAGS
end

build_root = ENV['PREFIX']
ldflags = ENV['LDFLAGS']
$LIBS << " -lzookeeper_st #{ldflags} -lm"

have_func('rb_thread_blocking_region')
have_func('rb_thread_fd_select')

$CFLAGS << ' -Wall' if ZK_DEV
create_makefile 'zookeeper_c'

