/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.cgoban;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.swing.AudioWidget;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.speex.StreamPlayer;
import org.igoweb.util.speex.StreamRecorder;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.TBlock;

public class SpeexTest
extends DFrame
implements ActionListener,
EventListener,
ChangeListener {
    private static final int INT_GAIN_MIN = -100;
    private static final int INT_GAIN_MAX = 400;
    private static final int INT_GAIN_10DB = 100;
    private JButton recordBut;
    private JButton playBut;
    private StreamRecorder recorder;
    private ByteArrayOutputStream recordOut;
    private VolumeTrackingPlayer player;
    private Timer timer;
    private TBlock testResultsOut;
    private JSlider gainSlider;
    private static final float RECOMMENDED_AMPLITUDE = 20000.0f;

    public SpeexTest() {
        super(Defs.getString(-382651048));
        this.addButton(Defs.getString(1436228514), this);
        this.getMainPanel().add("xGrow=t,yGrow=f,xSpan=2", new TBlock(Defs.getString(-382651045), 40));
        this.recordBut = new JButton(Defs.getString(-382651047));
        this.recordBut.addActionListener(this);
        this.getMainPanel().add("x=0,xSpan=1", this.recordBut);
        this.playBut = new JButton(Defs.getString(-382651046));
        this.playBut.addActionListener(this);
        this.playBut.setEnabled(false);
        this.getMainPanel().add(this.playBut);
        JPanel panel = new JPanel(new BorderLayout());
        this.gainSlider = new JSlider(0, -100, 400, this.convertGainToInt(StreamRecorder.getGain()));
        this.gainSlider.setMinorTickSpacing(100);
        this.gainSlider.setPaintTicks(true);
        this.gainSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        Font labelFont = UIManager.getFont("Label.font");
        labelFont = labelFont.deriveFont((float)labelFont.getSize() * 0.75f);
        JLabel label = new JLabel(Defs.getString(-382651034));
        label.setFont(labelFont);
        labels.put(new Integer(0), label);
        label = new JLabel(Defs.getString(-382651033));
        label.setFont(labelFont);
        labels.put(new Integer(-100), label);
        label = new JLabel(Defs.getString(-382651064));
        label.setFont(labelFont);
        labels.put(new Integer(400), label);
        this.gainSlider.setLabelTable(labels);
        panel.add("North", this.gainSlider);
        panel.add(new TBlock(Defs.getString(-382651035), 40));
        panel.setBorder(BorderFactory.createTitledBorder(Defs.getString(-382651036)));
        this.getMainPanel().add("x=0,xSpan=2", panel);
        this.gainSlider.addChangeListener(this);
        this.testResultsOut = new TBlock(Defs.getString(-382651043), 40);
        JPanel outerBorder = new JPanel();
        outerBorder.setLayout(new BorderLayout());
        outerBorder.setBorder(BorderFactory.createTitledBorder(Defs.getString(-382651044)));
        outerBorder.add(this.testResultsOut);
        this.getMainPanel().add("x=0,yGrow=t", outerBorder);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.recordBut) {
            if (this.player != null) {
                this.player.stop();
                this.player = null;
            }
            this.recordBut.setEnabled(false);
            this.playBut.setEnabled(true);
            this.recordOut = new ByteArrayOutputStream();
            this.recorder = new StreamRecorder(this.recordOut, AudioWidget.FRAMES_PER_PACKET);
            this.recorder.addListener(this);
            this.timer = new Timer(60000, this);
            this.timer.start();
            this.recorder.start();
        } else if (src == this.playBut) {
            if (!this.closeRecorder()) {
                return;
            }
            if (this.player != null) {
                this.player.stop();
                this.player = null;
            }
            this.player = new VolumeTrackingPlayer(new ByteArrayInputStream(this.recordOut.toByteArray()), AudioWidget.FRAMES_PER_PACKET);
            this.player.addListener(this);
            this.player.start();
        } else if (src instanceof JButton) {
            this.dispose();
        } else if (event.getSource() == this.timer && this.closeRecorder()) {
            this.recordBut.setEnabled(true);
        }
    }

    private boolean closeRecorder() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.recorder != null && !this.recorder.stop(750)) {
            this.testResultsOut.setText(Defs.getString(-382651037));
            this.recorder = null;
            return false;
        }
        return true;
    }

    @Override
    public void handleEvent(final Event event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpeexTest.this.gotSpeexEvent(event);
            }
        });
    }

    private void gotSpeexEvent(Event event) {
        switch (event.type) {
            case 3: {
                this.testResultsOut.setText(Defs.getString(-903340505));
                this.recordBut.setEnabled(true);
                this.playBut.setEnabled(false);
                break;
            }
            case 4: 
            case 5: {
                this.testResultsOut.setText(Defs.getString(-382651041, Config.get("adminEmail")));
                this.recordBut.setEnabled(true);
                this.playBut.setEnabled(false);
                break;
            }
            case 6: {
                this.testResultsOut.setText(Defs.getString(-382651037));
                break;
            }
            case 7: {
                this.testResultsOut.setText(Defs.getString(-903340501));
                this.recordBut.setEnabled(true);
                this.playBut.setEnabled(false);
                break;
            }
            case 0: {
                this.testResultsOut.setText(Defs.getString(-382651038));
                this.recordBut.setEnabled(true);
                break;
            }
            case 1: {
                this.recordBut.setEnabled(true);
                int msgId = -382651042;
                if (this.player != null && this.player.getMaxAmplitude() < 20000.0f) {
                    msgId = -382651039;
                }
                this.testResultsOut.setText(Defs.getString(msgId));
                break;
            }
            case 2: {
                this.recordBut.setEnabled(true);
                this.testResultsOut.setText(Defs.getString(-382651040, Config.get("adminEmail")));
            }
        }
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        Dimension dim = new Dimension(super.getDefaultPreferredSize());
        if (dim.height < dim.width) {
            dim.height = dim.width;
        }
        return dim;
    }

    @Override
    public void dispose() {
        if (this.recorder != null) {
            this.recorder.stop(500);
            this.recorder = null;
        }
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        super.dispose();
    }

    private int convertGainToInt(float floatGain) {
        return (int)(Math.log(floatGain) * (100.0 / Math.log(2.0)));
    }

    private float convertGainToFloat(int intGain) {
        return (float)Math.exp(Math.log(2.0) / 100.0 * (double)intGain);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        StreamRecorder.setGain(this.convertGainToFloat(this.gainSlider.getValue()));
    }

    public static class VolumeTrackingPlayer
    extends StreamPlayer {
        private float maxAmplitude = 0.0f;
        private float rmsSum = 0.0f;
        private int numSamples = 0;

        public VolumeTrackingPlayer(InputStream in, int framesPerPacket) {
            super(in, framesPerPacket);
        }

        @Override
        protected boolean writePcmData(float[] floatPcmData, int bufferedFrames) {
            for (int i = 0; i < floatPcmData.length; ++i) {
                float val = floatPcmData[i];
                this.rmsSum += val * val;
                ++this.numSamples;
                if (!(Math.abs(val) > this.maxAmplitude)) continue;
                this.maxAmplitude = Math.abs(val);
            }
            return super.writePcmData(floatPcmData, 0);
        }

        public float getMaxAmplitude() {
            return this.maxAmplitude;
        }

        public float getRmsAmplitude() {
            return (float)Math.sqrt(this.rmsSum / (float)this.numSamples);
        }
    }
}

