/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.UIManager;

public class FwdBackIcon
implements Icon {
    private final int iconId;
    public static final int REWIND = 0;
    public static final int BACK = 1;
    public static final int FORWARD = 2;
    public static final int FASTFORWARD = 3;
    public static final int STOP = 4;
    public static final int BIDI = 5;
    public static final int PAUSE = 6;
    public static final int HOME = 7;
    public static final int END = 8;

    public FwdBackIcon(int iconId) {
        this.iconId = iconId;
    }

    @Override
    public int getIconHeight() {
        return UIManager.getInt("org.igoweb.fontH");
    }

    @Override
    public int getIconWidth() {
        return UIManager.getInt("org.igoweb.fontH");
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (c.isEnabled()) {
            g2d.setColor(c.getForeground());
        } else {
            g2d.setColor(UIManager.getColor("org.igoweb.stdBg").darker());
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float baseX = x;
        float baseY = y;
        float size = UIManager.getInt("org.igoweb.fontH");
        GeneralPath path = new GeneralPath(1, 8);
        float direction = size * 0.5f;
        switch (this.iconId) {
            case 0: {
                baseX += size;
                direction = -direction;
                break;
            }
            case 1: {
                baseX += size * 0.75f;
                direction = -direction;
                break;
            }
            case 2: {
                baseX += size * 0.25f;
                break;
            }
            case 3: {
                break;
            }
            case 7: {
                baseX += size;
                direction = -direction;
            }
            case 8: {
                path.moveTo(baseX + direction * 2.0f, baseY);
                path.lineTo(baseX + direction * 1.8f, baseY);
                path.lineTo(baseX + direction * 1.8f, baseY + size);
                path.lineTo(baseX + direction * 2.0f, baseY + size);
                path.closePath();
                direction = (float)((double)direction * 0.9);
                break;
            }
            case 4: {
                path.moveTo(baseX + size * 0.25f, baseY + size * 0.25f);
                path.lineTo(baseX + size * 0.75f, baseY + size * 0.25f);
                path.lineTo(baseX + size * 0.75f, baseY + size * 0.75f);
                path.lineTo(baseX + size * 0.25f, baseY + size * 0.75f);
                break;
            }
            case 5: {
                path.moveTo(baseX + direction, baseY + size * 0.2f);
                path.lineTo(baseX + size * 0.8f, baseY + direction);
                path.lineTo(baseX + direction, baseY + size * 0.8f);
                path.lineTo(baseX + size * 0.2f, baseY + direction);
                break;
            }
            case 6: {
                path.moveTo(baseX, baseY);
                path.lineTo(baseX + size * 0.33333334f, baseY);
                path.lineTo(baseX + size * 0.33333334f, baseY + size);
                path.lineTo(baseX, baseY + size);
                path.closePath();
                path.moveTo(baseX + size * 0.6666667f, baseY);
                path.lineTo(baseX + size, baseY);
                path.lineTo(baseX + size, baseY + size);
                path.lineTo(baseX + size * 0.6666667f, baseY + size);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.iconId < 4 || this.iconId > 6) {
            path.moveTo(baseX, baseY);
            path.lineTo(baseX + direction, baseY + size * 0.5f);
            if (this.iconId == 0 || this.iconId == 3 || this.iconId == 7 || this.iconId == 8) {
                path.lineTo(baseX + direction, baseY);
                path.lineTo(baseX + direction * 2.0f, baseY + size * 0.5f);
                path.lineTo(baseX + direction, baseY + size);
                path.lineTo(baseX + direction, baseY + size * 0.5f);
            }
            path.lineTo(baseX, baseY + size);
        }
        path.closePath();
        g2d.fill(path);
        g2d.dispose();
    }
}

