/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class HtmlUtil {
    private static final HashMap<String, Character> escapeChars = new HashMap();

    private HtmlUtil() {
    }

    public static String htmlToText(String htmlIn) {
        CvtState cvt = new CvtState();
        for (int i = htmlIn.indexOf("<body>"); i < htmlIn.length(); ++i) {
            int j;
            char c = htmlIn.charAt(i);
            if (c == '<') {
                j = i + 1;
                if (htmlIn.charAt(j) == '/') {
                    ++j;
                }
                while ((c = htmlIn.charAt(j)) > 'a' && c < 'z' || c > 'A' && c < 'Z' || c > '0' && c < '9') {
                    ++j;
                }
                String tagName = htmlIn.substring(i, j).toLowerCase(Locale.US);
                HtmlUtil.processTag(cvt, tagName);
                while (htmlIn.charAt(i) != '>') {
                    ++i;
                }
                continue;
            }
            if (c == '&') {
                j = i;
                do {
                    if (j != htmlIn.length()) continue;
                    throw new IllegalArgumentException("Unterminated character element in " + htmlIn);
                } while (htmlIn.charAt(j++) != ';');
                Character charObj = escapeChars.get(htmlIn.substring(i, j));
                cvt.appendChar(charObj == null ? (char)'?' : (char)charObj.charValue());
                i = j - 1;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (cvt.spaceAdded) continue;
                cvt.lastSpace = cvt.result.length();
                cvt.result.append(' ');
                ++cvt.curLineLen;
                cvt.spaceAdded = true;
                continue;
            }
            cvt.appendChar(c);
        }
        while (cvt.result.length() > 1 && cvt.result.charAt(cvt.result.length() - 1) == '\n' && cvt.result.charAt(cvt.result.length() - 2) == '\n') {
            cvt.result.setLength(cvt.result.length() - 1);
        }
        return cvt.result.toString();
    }

    private static void processTag(CvtState cvt, String tagName) {
        if (tagName.equals("<p") || tagName.equals("</p") || tagName.equals("<h1") || tagName.equals("</h1") || tagName.equals("<h2") || tagName.equals("</h2") || tagName.equals("<h3") || tagName.equals("</h3") || tagName.equals("<h4") || tagName.equals("</h4") || tagName.equals("<h5") || tagName.equals("</h5") || tagName.equals("<h6") || tagName.equals("</h6")) {
            cvt.addBreaks(2);
        } else if (tagName.equals("<blockquote")) {
            cvt.indent += 3;
            cvt.addBreaks(2);
        } else if (tagName.equals("</blockquote")) {
            cvt.indent -= 3;
            cvt.addBreaks(2);
        } else if (tagName.equals("<br")) {
            cvt.addBreaks(1);
        } else if (tagName.equals("<ul")) {
            cvt.indent += 3;
            cvt.bulletNum = -1;
            cvt.addBreaks(2);
        } else if (tagName.equals("</ul")) {
            cvt.indent -= 3;
            cvt.addBreaks(2);
        } else if (tagName.equals("<ol")) {
            cvt.indent += 3;
            cvt.bulletNum = 1;
            cvt.addBreaks(2);
        } else if (tagName.equals("</ol")) {
            cvt.indent -= 3;
            cvt.addBreaks(2);
        } else if (tagName.equals("<li")) {
            cvt.addBreaks(1);
            cvt.bulletNeeded = true;
        } else if (tagName.equals("</li")) {
            if (cvt.bulletNum > 0) {
                ++cvt.bulletNum;
            }
        } else if (tagName.equals("<a")) {
            System.err.println("  <a");
            cvt.inTag = true;
        } else if (tagName.equals("</a")) {
            System.err.println("  </a");
            cvt.inTag = false;
        }
    }

    public static String textToHtml(String in, boolean xhtml, boolean wrap) {
        StringBuilder out = new StringBuilder();
        if (wrap) {
            out.append("<html>");
        }
        boolean change = HtmlUtil.mungeHtml(in, out, xhtml ? "<br/>" : "<br>");
        if (wrap) {
            out.append("</html>");
        }
        return change || wrap ? out.toString() : in;
    }

    public static String escapeHtml(String in) {
        StringBuilder out = new StringBuilder();
        return HtmlUtil.mungeHtml(in, out, "\n") ? out.toString() : in;
    }

    private static boolean mungeHtml(String in, StringBuilder out, String eol) {
        boolean change = false;
        boolean eolSame = eol.equals("\n");
        int len = in.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '&': {
                    change = true;
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    change = true;
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    change = true;
                    out.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    change = true;
                    out.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    change = change || !eolSame;
                    out.append(eol);
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return change;
    }

    public static void main(String[] args) throws IOException {
        StringBuilder in = new StringBuilder("<html><body>");
        while (true) {
            int c;
            if ((c = System.in.read()) == -1) {
                in.append("</body></html>");
                System.out.println(HtmlUtil.htmlToText(in.toString()));
                System.exit(0);
            }
            in.append((char)c);
        }
    }

    static {
        escapeChars.put("&amp;", new Character('&'));
        escapeChars.put("&nbsp;", new Character(' '));
        escapeChars.put("&lt;", new Character('<'));
        escapeChars.put("&quot;", new Character('\"'));
        escapeChars.put("&gt;", new Character('>'));
        escapeChars.put("&mdash;", new Character('-'));
        escapeChars.put("&agrave;", new Character('\u00e0'));
        escapeChars.put("&eacute;", new Character('\u00e9'));
        escapeChars.put("&egrave;", new Character('\u00e8'));
        escapeChars.put("&iacute;", new Character('\u00ed'));
        escapeChars.put("&scaron;", new Character('\u0161'));
    }

    private static class CvtState {
        StringBuilder result = new StringBuilder();
        int numBreaks = 100;
        int curLineLen = -1;
        int indent = 0;
        boolean spaceAdded = true;
        int lastSpace = -1;
        int bulletNum;
        boolean bulletNeeded = false;
        boolean inTag;

        private CvtState() {
        }

        void appendChar(char c) {
            this.spaceAdded = false;
            if (this.curLineLen < 0) {
                this.curLineLen = this.startLine();
            }
            if (++this.curLineLen >= 72) {
                if (this.lastSpace == -1) {
                    if (!this.inTag) {
                        this.result.append('\n');
                        this.curLineLen = this.startLine();
                    }
                } else {
                    String tail = this.result.substring(this.lastSpace + 1);
                    this.result.setLength(this.lastSpace);
                    this.result.append('\n');
                    this.lastSpace = -1;
                    this.curLineLen = this.startLine() + tail.length();
                    this.result.append(tail);
                }
            }
            this.result.append(c);
            this.numBreaks = 0;
        }

        void addBreaks(int breaks) {
            if (this.numBreaks < breaks) {
                while (this.numBreaks < breaks) {
                    this.result.append('\n');
                    ++this.numBreaks;
                }
            }
            this.spaceAdded = true;
            this.curLineLen = -1;
        }

        int startLine() {
            if (this.numBreaks > 0 && this.bulletNeeded) {
                this.bulletNeeded = false;
                if (this.bulletNum > 0) {
                    for (int j = 0; j < this.indent - 3; ++j) {
                        this.result.append(' ');
                    }
                    this.result.append(this.bulletNum).append(". ");
                } else {
                    for (int j = 0; j < this.indent - 2; ++j) {
                        this.result.append(' ');
                    }
                    this.result.append("* ");
                }
            } else {
                for (int j = 0; j < this.indent; ++j) {
                    this.result.append(' ');
                }
            }
            return this.indent;
        }
    }
}

