/*
 * Decompiled with CFR 0.152.
 */
package free.jin.freechess;

import free.jin.AbstractServer;
import free.jin.Connection;
import free.jin.ConnectionDetails;
import free.jin.UsernamePolicy;
import free.jin.freechess.JinFreechessConnection;

public class FreechessServer
extends AbstractServer {
    protected UsernamePolicy createUsernamePolicy() {
        return new UsernamePolicy(){

            public boolean isSame(String string, String string2) {
                return string.equalsIgnoreCase(string2);
            }

            public String invalidityReason(String string) {
                int n = string.length();
                if (n < 3 || n > 17) {
                    return FreechessServer.this.getI18n().getString("usernameLengthErrorMessage");
                }
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
                    return FreechessServer.this.getI18n().getFormattedString("usernameIllegalCharacterErrorMessage", new Object[]{"" + c});
                }
                return null;
            }

            public String getGuestUsername() {
                return "guest";
            }
        };
    }

    public Connection createConnection(ConnectionDetails connectionDetails) {
        return new JinFreechessConnection(connectionDetails.getUsername(), connectionDetails.getPassword());
    }
}

