/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console;

import free.jin.GameListItem;
import free.jin.I18n;
import free.jin.Preferences;
import free.jin.console.Command;
import free.jin.console.Console;
import free.jin.console.GameListTableModel;
import free.jin.event.GameListEvent;
import free.workarounds.FixedJTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class GameListTable
extends FixedJTable {
    protected final Console console;
    protected final GameListEvent gameListEvent;
    private JPopupMenu popup;

    public GameListTable(Console console, GameListEvent gameListEvent) {
        this.console = console;
        this.gameListEvent = gameListEvent;
        this.setModel(this.createGameListModel(gameListEvent));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (!toolTipManager.isEnabled()) {
            toolTipManager.setEnabled(true);
        }
        toolTipManager.registerComponent((JComponent)((Object)this));
        this.enableEvents(16L);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected TableModel createGameListModel(GameListEvent gameListEvent) {
        return new GameListTableModel(gameListEvent);
    }

    protected JPopupMenu createPopup() {
        String string;
        I18n i18n = this.console.getConsoleManager().getI18n();
        int n = this.getSelectedRowCount();
        if (n == 0) {
            return null;
        }
        String string2 = this.commandNameForID(this.gameListEvent.getID());
        if (string2 == null) {
            return null;
        }
        Preferences preferences = this.console.getPrefs();
        int n2 = preferences.getInt((string = "gameListPopup.") + "itemCount", 0);
        if (n2 == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string3 = string + i + ".";
            String string4 = preferences.getString(string3 + "type", "serverCommand");
            if ("serverCommand".equals(string4)) {
                String string5 = preferences.getString(string3 + "command");
                String string6 = preferences.getString(string3 + "nameKey");
                String string7 = i18n.getString(string6);
                boolean bl = preferences.getBool(string3 + "multiSelectSupported", true);
                if (n > 1 && !bl) continue;
                JMenuItem jMenuItem = new JMenuItem(string7);
                jMenuItem.setActionCommand(string5);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = ((AbstractButton)actionEvent.getSource()).getActionCommand();
                        int[] nArray = GameListTable.this.getSelectedRows();
                        for (int i = 0; i < nArray.length; ++i) {
                            GameListItem gameListItem = GameListTable.this.gameListEvent.getItem(nArray[i]);
                            String string2 = GameListTable.this.insertItemProperties(string, gameListItem, '$');
                            GameListTable.this.console.issueCommand(new Command(string2, 0L));
                        }
                    }
                });
                ++n3;
                jPopupMenu.add(jMenuItem);
                continue;
            }
            if ("separator".equals(string4)) {
                jPopupMenu.addSeparator();
                continue;
            }
            throw new IllegalArgumentException("Unknown game list popup item type: " + string4);
        }
        if (n3 == 0) {
            return null;
        }
        return jPopupMenu;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n == -1 || n2 == -1) {
            return null;
        }
        int n3 = this.getColumnModel().getColumn(n).getWidth();
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n2, n);
        Object object = this.getModel().getValueAt(n2, n);
        Component component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), object, false, false, n2, n);
        int n4 = component.getPreferredSize().width;
        if (n4 > n3) {
            return String.valueOf(object);
        }
        return null;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (this.getToolTipText(mouseEvent) == null) {
            return null;
        }
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        Rectangle rectangle = this.getCellRect(n2, n, false);
        return rectangle.getLocation();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2 && (mouseEvent.getModifiers() & 0x10) != 0) {
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            GameListItem gameListItem = this.gameListEvent.getItem(n);
            String string = this.console.getPrefs().getString(this.commandNameForID(this.gameListEvent.getID()) + "-game-list-action");
            string = this.insertItemProperties(string, gameListItem, '$');
            this.console.issueCommand(new Command(string, 0L));
        } else if (mouseEvent.isPopupTrigger()) {
            this.popup = this.createPopup();
            if (this.popup != null) {
                JRootPane jRootPane = SwingUtilities.getRootPane((Component)((Object)this));
                Dimension dimension = jRootPane.getSize();
                Point point = SwingUtilities.convertPoint((Component)((Object)this), mouseEvent.getPoint(), jRootPane);
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = this.popup.getWidth();
                int n4 = this.popup.getHeight();
                if (point.x + n3 > dimension.width) {
                    n -= n3;
                }
                if (point.y + n4 > dimension.height) {
                    n2 -= n4;
                }
                this.popup.setLightWeightPopupEnabled(false);
                this.popup.setSelected(null);
                this.popup.show((Component)((Object)this), n, n2);
            }
        }
    }

    private String insertItemProperties(String string, GameListItem gameListItem, char c) {
        String string2 = String.valueOf(c);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string2)) {
                if (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                        String string5 = this.getItemProperty(gameListItem, string4);
                        if (string5 != null) {
                            stringBuffer.append(string5);
                            continue;
                        }
                        stringBuffer.append(string2).append(string5).append(string2);
                        continue;
                    }
                    stringBuffer.append(string3).append(string4);
                    continue;
                }
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    protected String getItemProperty(GameListItem gameListItem, String string) {
        if (string.equals("id")) {
            return gameListItem.getID();
        }
        if (string.equals("index")) {
            return String.valueOf(gameListItem.getIndex());
        }
        return null;
    }

    protected String commandNameForID(int n) {
        switch (n) {
            case 1: {
                return "history";
            }
            case 4: {
                return "stored";
            }
            case 3: {
                return "liblist";
            }
            case 2: {
                return "search";
            }
        }
        return null;
    }
}

