/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.PipedInputStream;
import free.util.PipedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class PipedStreams {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private final PipedInputStream in;
    private final PipedOutputStream out;
    private volatile int soTimeout = 0;
    private byte[] buf;
    private final boolean growBuf;
    private int readIndex = 0;
    private int writeIndex = 0;
    private boolean writerClosed = false;
    private boolean readerClosed = false;
    private Object writeLock = new String("Write Lock for PipedStreams");
    private Object readLock = new String("Read Lock for PipedStream");

    public PipedStreams() {
        this(2048, false);
    }

    public PipedStreams(int n) {
        this(n, false);
    }

    public PipedStreams(boolean bl) {
        this(2048, bl);
    }

    public PipedStreams(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException("The buffer size must be a positive integer");
        }
        this.in = new PipedInputStream(this);
        this.out = new PipedOutputStream(this);
        this.growBuf = bl;
        this.buf = new byte[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoTimeout(int n) {
        Object object = this.readLock;
        synchronized (object) {
            this.soTimeout = n;
        }
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public PipedInputStream getInputStream() {
        return this.in;
    }

    public PipedOutputStream getOutputStream() {
        return this.out;
    }

    synchronized int available() {
        if (this.readerClosed) {
            return 0;
        }
        return this.availableImpl();
    }

    private int availableImpl() {
        if (this.writeIndex >= this.readIndex) {
            return this.writeIndex - this.readIndex;
        }
        return this.writeIndex + this.buf.length - this.readIndex;
    }

    private int availableSpace() {
        return this.buf.length - this.availableImpl() - 1;
    }

    private void growBuf(int n) {
        int n2 = n < this.buf.length ? this.buf.length : n;
        byte[] byArray = new byte[this.buf.length + n2];
        System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
        this.buf = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void write(int n) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.readerClosed || this.writerClosed) {
                throw new IOException("Stream closed");
            }
            while (this.availableSpace() == 0) {
                if (this.growBuf) {
                    this.growBuf(1);
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            if (this.readerClosed || this.writerClosed) {
                throw new IOException("Stream closed");
            }
            this.buf[this.writeIndex++] = (byte)(n & 0xFF);
            if (this.writeIndex == this.buf.length) {
                this.writeIndex = 0;
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.readerClosed || this.writerClosed) {
                throw new IOException("Stream closed");
            }
            if (this.growBuf && n2 > this.availableSpace()) {
                this.growBuf(n2 - this.availableSpace());
            }
            while (n2 > 0) {
                while (this.availableSpace() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
                int n3 = this.availableSpace();
                int n4 = n2 > n3 ? n3 : n2;
                int n5 = this.buf.length - this.writeIndex >= n4 ? n4 : this.buf.length - this.writeIndex;
                int n6 = n4 - n5 > 0 ? n4 - n5 : 0;
                System.arraycopy(byArray, n, this.buf, this.writeIndex, n5);
                System.arraycopy(byArray, n + n5, this.buf, 0, n6);
                n += n4;
                n2 -= n4;
                this.writeIndex = (this.writeIndex + n4) % this.buf.length;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int read() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.readerClosed) {
                throw new IOException("Stream closed");
            }
            long l = System.currentTimeMillis();
            while (this.available() == 0) {
                if (this.writerClosed) {
                    return -1;
                }
                long l2 = System.currentTimeMillis();
                if (this.soTimeout != 0 && l2 - l >= (long)this.soTimeout) {
                    throw new InterruptedIOException();
                }
                try {
                    if (this.soTimeout == 0) {
                        this.wait();
                    } else {
                        this.wait((long)this.soTimeout + l2 - l);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                if (!this.readerClosed) continue;
                throw new IOException("Stream closed");
            }
            int n = this.buf[this.readIndex++];
            if (this.readIndex == this.buf.length) {
                this.readIndex = 0;
            }
            this.notifyAll();
            return n < 0 ? n + 256 : n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.readerClosed) {
                throw new IOException("Stream closed");
            }
            long l = System.currentTimeMillis();
            while (this.available() == 0) {
                if (this.writerClosed) {
                    return -1;
                }
                long l2 = System.currentTimeMillis();
                if (this.soTimeout != 0 && l2 - l >= (long)this.soTimeout) {
                    throw new InterruptedIOException();
                }
                try {
                    if (this.soTimeout == 0) {
                        this.wait();
                    } else {
                        this.wait((long)this.soTimeout + l2 - l);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                if (!this.readerClosed) continue;
                throw new IOException("Stream closed");
            }
            int n3 = this.available();
            int n4 = n2 > n3 ? n3 : n2;
            int n5 = this.buf.length - this.readIndex > n4 ? n4 : this.buf.length - this.readIndex;
            int n6 = n4 - n5 > 0 ? n4 - n5 : 0;
            System.arraycopy(this.buf, this.readIndex, byArray, n, n5);
            System.arraycopy(this.buf, 0, byArray, n + n5, n6);
            this.readIndex = (this.readIndex + n4) % this.buf.length;
            this.notifyAll();
            return n4;
        }
    }

    synchronized void closeWriter() {
        if (this.writerClosed) {
            throw new IllegalStateException("Already closed");
        }
        this.writerClosed = true;
        this.notifyAll();
    }

    synchronized void closeReader() {
        if (this.readerClosed) {
            throw new IllegalStateException("Already closed");
        }
        this.readerClosed = true;
        this.notifyAll();
    }
}

