/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CardLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = -4328196481005934313L;
    private static final int FIRST = 0;
    private static final int LAST = 1;
    private static final int NEXT = 2;
    private static final int PREV = 3;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int PREF = 2;
    private int hgap;
    private int vgap;
    private Hashtable tab;

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Object " + object + " is not a string");
        }
        this.addLayoutComponent((String)object, component);
    }

    public void addLayoutComponent(String string, Component component) {
        this.tab.put(string, component);
        boolean bl = false;
        if (this.tab.size() == 1) {
            bl = true;
        }
        component.setVisible(bl);
    }

    public void first(Container container) {
        this.gotoComponent(container, 0);
    }

    public int getHgap() {
        return this.hgap;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void invalidateLayout(Container container) {
    }

    public void last(Container container) {
        this.gotoComponent(container, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.width;
            int n2 = container.height;
            Insets insets = container.getInsets();
            int n3 = container.ncomponents;
            Component[] componentArray = container.component;
            int n4 = insets.left + this.hgap;
            int n5 = insets.top + this.vgap;
            n = n - 2 * this.hgap - insets.left - insets.right;
            n2 = n2 - 2 * this.vgap - insets.top - insets.bottom;
            int n6 = 0;
            while (n6 < n3) {
                componentArray[n6].setBounds(n4, n5, n, n2);
                ++n6;
            }
            return;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.getSize(container, 1);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSize(container, 0);
    }

    public void next(Container container) {
        this.gotoComponent(container, 2);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSize(container, 2);
    }

    public void previous(Container container) {
        this.gotoComponent(container, 3);
    }

    public void removeLayoutComponent(Component component) {
        Enumeration enumeration = this.tab.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (this.tab.get(object) != component) continue;
            this.tab.remove(object);
            Container container = component.getParent();
            this.next(container);
            break;
        }
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void show(Container container, String string) {
        if (string == null) {
            return;
        }
        if (container.getLayout() != this) {
            throw new IllegalArgumentException("parent's layout is not this CardLayout");
        }
        Object object = this.tab.get(string);
        if (object != null) {
            int n = container.ncomponents;
            Component[] componentArray = container.component;
            int n2 = 0;
            while (n2 < n) {
                if (componentArray[n2].isVisible()) {
                    if (object == componentArray[n2]) {
                        return;
                    }
                    componentArray[n2].setVisible(false);
                }
                ++n2;
            }
            ((Component)object).setVisible(true);
        }
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.hgap + ',' + this.vgap + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void gotoComponent(Container container, int n) {
        if (container.getLayout() != this) {
            throw new IllegalArgumentException("parent's layout is not this CardLayout");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2 = container.ncomponents;
            Component[] componentArray = container.component;
            if (n2 == 1) {
                componentArray[0].setVisible(true);
                return;
            }
            int n3 = -1;
            if (n == 0) {
                n3 = 0;
            } else if (n == 1) {
                n3 = n2 - 1;
            }
            int n4 = 0;
            while (n4 < n2) {
                if (componentArray[n4].isVisible()) {
                    if (n == 2) {
                        n3 = n4 + 1;
                        if (n3 == n2) {
                            n3 = 0;
                        }
                    } else if (n == 3) {
                        n3 = n4 - 1;
                        if (n3 < 0) {
                            n3 = n2 - 1;
                        }
                    } else if (n3 == n4) {
                        return;
                    }
                    componentArray[n4].setVisible(false);
                    if (n3 >= 0) break;
                }
                ++n4;
            }
            if (n3 >= 0 && n3 < n2) {
                componentArray[n3].setVisible(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Dimension getSize(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2 = 0;
            int n3 = 0;
            int n4 = container.ncomponents;
            Component[] componentArray = container.component;
            int n5 = 0;
            while (true) {
                if (n5 >= n4) {
                    Insets insets = container.getInsets();
                    n3 += 2 * this.vgap + insets.bottom + insets.top;
                    if ((n2 += 2 * this.hgap + insets.right + insets.left) < 0) {
                        n2 = Integer.MAX_VALUE;
                    }
                    if (n3 < 0) {
                        n3 = Integer.MAX_VALUE;
                    }
                    return new Dimension(n2, n3);
                }
                Dimension dimension = n == 0 ? componentArray[n5].getMinimumSize() : (n == 1 ? componentArray[n5].getMaximumSize() : componentArray[n5].getPreferredSize());
                n2 = Math.max(dimension.width, n2);
                n3 = Math.max(dimension.height, n3);
                ++n5;
            }
        }
    }

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
        this.tab = new Hashtable();
    }
}

