/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Point;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.reflect.Constructor;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ColorModel
implements Transparency {
    protected int pixel_bits;
    protected int transferType;
    int[] bits;
    ColorSpace cspace;
    int transparency;
    boolean hasAlpha;
    boolean isAlphaPremultiplied;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$java$awt$color$ColorSpace;

    static int[] nArray(int n, int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, n);
        return nArray;
    }

    static byte[] nArray(byte by, int n) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return byArray;
    }

    ColorModel cloneColorModel(ColorSpace colorSpace) {
        ColorModel colorModel;
        Class clazz = this.getClass();
        try {
            Class clazz2;
            Class[] classArray = new Class[7];
            classArray[0] = Integer.TYPE;
            Class clazz3 = array$I;
            if (clazz3 == null) {
                clazz3 = classArray[1] = (array$I = ColorModel.class("[I", true));
            }
            if ((clazz2 = class$java$awt$color$ColorSpace) == null) {
                clazz2 = class$java$awt$color$ColorSpace = ColorModel.class("[Ljava.awt.color.ColorSpace;", false);
            }
            classArray[2] = clazz2;
            classArray[3] = Boolean.TYPE;
            classArray[4] = Boolean.TYPE;
            classArray[5] = Integer.TYPE;
            classArray[6] = Integer.TYPE;
            Constructor constructor = clazz.getConstructor(classArray);
            colorModel = (ColorModel)constructor.newInstance(new Object[]{new Integer(this.pixel_bits), this.bits, colorSpace, this.hasAlpha, this.isAlphaPremultiplied, new Integer(this.transparency), new Integer(this.transferType)});
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
        return colorModel;
    }

    public void finalize() {
    }

    public static ColorModel getRGBdefault() {
        return new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    }

    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    public final boolean isAlphaPremultiplied() {
        return this.isAlphaPremultiplied;
    }

    public int getPixelSize() {
        return this.pixel_bits;
    }

    public int getComponentSize(int n) {
        return this.bits[n];
    }

    public int[] getComponentSize() {
        return this.bits;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public int getNumComponents() {
        return this.getNumColorComponents() + this.hasAlpha;
    }

    public int getNumColorComponents() {
        return this.cspace.getNumComponents();
    }

    public abstract int getRed(int var1);

    public abstract int getGreen(int var1);

    public abstract int getBlue(int var1);

    public abstract int getAlpha(int var1);

    public int getRGB(int n) {
        return (this.getAlpha(n) & 0xFF) << 24 | (this.getRed(n) & 0xFF) << 16 | (this.getGreen(n) & 0xFF) << 8 | this.getBlue(n) & 0xFF;
    }

    final int getPixelFromArray(Object object) {
        DataBuffer dataBuffer = Buffers.createBufferFromData(this.transferType, object, 1);
        Object object2 = Buffers.getData(dataBuffer);
        return dataBuffer.getElem(0);
    }

    public int getRed(Object object) {
        return this.getRed(this.getPixelFromArray(object));
    }

    public int getGreen(Object object) {
        return this.getGreen(this.getPixelFromArray(object));
    }

    public int getBlue(Object object) {
        return this.getBlue(this.getPixelFromArray(object));
    }

    public int getAlpha(Object object) {
        return this.getAlpha(this.getPixelFromArray(object));
    }

    public int getRGB(Object object) {
        return (this.getAlpha(object) & 0xFF) << 24 | (this.getRed(object) & 0xFF) << 16 | (this.getGreen(object) & 0xFF) << 8 | this.getBlue(object) & 0xFF;
    }

    public Object getDataElements(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        throw new UnsupportedOperationException();
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        throw new UnsupportedOperationException();
    }

    public int[] getUnnormalizedComponents(float[] fArray, int n, int[] nArray, int n2) {
        int n3 = this.getNumComponents();
        if (nArray == null) {
            nArray = new int[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            float f = fArray[n++];
            int n5 = (int)(f * (float)((1 << this.getComponentSize(n4)) - 1));
            nArray[n2++] = n5;
            ++n4;
        }
        return nArray;
    }

    public float[] getNormalizedComponents(int[] nArray, int n, float[] fArray, int n2) {
        int n3 = this.getNumComponents();
        if (fArray == null) {
            fArray = new float[n2 + n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            float f = nArray[n++];
            float f2 = f / (float)((1 << this.getComponentSize(n4)) - 1);
            fArray[n2++] = f2;
            ++n4;
        }
        return fArray;
    }

    public float[] getNormalizedComponents(Object object, float[] fArray, int n) {
        throw new UnsupportedOperationException();
    }

    public int getDataElement(int[] nArray, int n) {
        throw new UnsupportedOperationException();
    }

    public int getDataElement(float[] fArray, int n) {
        return this.getDataElement(this.getUnnormalizedComponents(fArray, n, null, 0), 0);
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object getDataElements(float[] fArray, int n, Object object) {
        return this.getDataElements(this.getUnnormalizedComponents(fArray, n, null, 0), 0, object);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorModel)) {
            return false;
        }
        ColorModel colorModel = (ColorModel)object;
        boolean bl = false;
        if (this.pixel_bits == colorModel.pixel_bits && this.transferType == colorModel.transferType && this.transparency == colorModel.transparency && this.hasAlpha == colorModel.hasAlpha && this.isAlphaPremultiplied == colorModel.isAlphaPremultiplied && Arrays.equals(this.bits, colorModel.bits) && this.cspace.equals(colorModel.cspace)) {
            bl = true;
        }
        return bl;
    }

    public final ColorSpace getColorSpace() {
        return this.cspace;
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        if (this.isAlphaPremultiplied == bl) {
            return this;
        }
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getMinX();
        int n4 = writableRaster.getMinY();
        int n5 = n * n2;
        int n6 = this.getNumColorComponents();
        int n7 = this.getNumComponents();
        int n8 = (1 << this.getComponentSize(n6)) - 1;
        double[] dArray = writableRaster.getPixels(n3, n4, n, n2, (double[])null);
        int n9 = 0;
        while (n9 < n5) {
            double d = dArray[n9 * n7 + n6] * (double)n8;
            int n10 = 0;
            while (n10 < n6) {
                int n11 = n9 * n7 + n10;
                dArray[n11] = bl ? dArray[n11] / d : dArray[n11] * d;
                ++n10;
            }
            ++n9;
        }
        writableRaster.setPixels(0, 0, n, n2, dArray);
        return null;
    }

    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        return this.isCompatibleSampleModel(sampleModel);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return new WritableRaster(this.createCompatibleSampleModel(n, n2), new Point(0, 0));
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        boolean bl = false;
        if (sampleModel.getTransferType() == this.transferType) {
            bl = true;
        }
        return bl;
    }

    public final int getTransferType() {
        return this.transferType;
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        return null;
    }

    String stringParam() {
        return "pixel_bits=" + this.pixel_bits + ", cspace=" + this.cspace + ", transferType=" + this.transferType + ", transparency=" + this.transparency + ", hasAlpha=" + this.hasAlpha + ", isAlphaPremultiplied=" + this.isAlphaPremultiplied;
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.stringParam() + ']';
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public ColorModel(int n) {
        this(n * 4, ColorModel.nArray(n, 4), ColorSpace.getInstance(1000), true, false, 3, Buffers.smallestAppropriateTransferType(n * 4));
    }

    protected ColorModel(int n, int[] nArray, ColorSpace colorSpace, boolean bl, boolean bl2, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (nArray[n5] < 0) {
                throw new IllegalArgumentException();
            }
            n4 |= nArray[n5];
            ++n5;
        }
        if (nArray.length < colorSpace.getNumComponents() || n4 < 1) {
            throw new IllegalArgumentException();
        }
        this.pixel_bits = n;
        this.bits = nArray;
        this.cspace = colorSpace;
        this.hasAlpha = bl;
        this.isAlphaPremultiplied = bl2;
        this.transparency = n2;
        this.transferType = n3;
    }
}

