/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;

public class ImageIcon
implements Icon,
Serializable,
Accessible {
    private static final long serialVersionUID = 532615968316031794L;
    protected static Component component = new Component(){};
    protected static MediaTracker tracker = new MediaTracker(component);
    private static int id;
    Image image;
    String description;
    ImageObserver observer;
    private int loadStatus;
    private AccessibleContext accessibleContext;

    public ImageObserver getImageObserver() {
        return this.observer;
    }

    public void setImageObserver(ImageObserver newObserver) {
        this.observer = newObserver;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.loadImage(image);
        this.image = image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getIconHeight() {
        if (this.image == null) {
            return -1;
        }
        return this.image.getHeight(this.observer);
    }

    public int getIconWidth() {
        if (this.image == null) {
            return -1;
        }
        return this.image.getWidth(this.observer);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.image, x, y, this.observer != null ? this.observer : c);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadImage(Image image) {
        try {
            try {
                tracker.addImage(image, id);
                tracker.waitForID(++id - 1);
            }
            catch (InterruptedException ex) {}
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.loadStatus = tracker.statusID(id - 1, false);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.loadStatus = tracker.statusID(id - 1, false);
            return;
        }
    }

    public int getImageLoadStatus() {
        return this.loadStatus;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleImageIcon();
        }
        return this.accessibleContext;
    }

    public ImageIcon() {
    }

    public ImageIcon(String filename) {
        this(filename, filename);
    }

    public ImageIcon(String filename, String description) {
        this(Toolkit.getDefaultToolkit().getImage(filename), description);
    }

    public ImageIcon(byte[] imageData) {
        this(imageData, null);
    }

    public ImageIcon(byte[] imageData, String description) {
        this(Toolkit.getDefaultToolkit().createImage(imageData), description);
    }

    public ImageIcon(URL url) {
        this(url, null);
    }

    public ImageIcon(URL url, String description) {
        this(Toolkit.getDefaultToolkit().getImage(url), description);
    }

    public ImageIcon(Image image) {
        this(image, null);
    }

    public ImageIcon(Image image, String description) {
        this.setImage(image);
        this.setDescription(description);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleImageIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        private static final long serialVersionUID = 2113430526551336564L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public String getAccessibleIconDescription() {
            return ImageIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String newDescr) {
            ImageIcon.this.setDescription(newDescr);
        }

        public int getAccessibleIconHeight() {
            return ImageIcon.this.getIconHeight();
        }

        public int getAccessibleIconWidth() {
            return ImageIcon.this.getIconWidth();
        }

        protected AccessibleImageIcon() {
        }
    }
}

