package TDS::AccessLog::Item;
# $Id: Item.pm,v 1.12 2001/01/03 08:20:47 tom Exp $
################################################################

=head1 NAME

TDS::AccessLog::Item - item object class used by access analysis

=head1 SYNOPSIS

 use TDS::AccessLog::Item;

 $line = "URI referer date_time remote\host hua id times\n"; # tab separated
 $item = new TDS::AccessLog::Item;
 $item->Set($line);
 print $item->uri, $item->referer;


=cut

use strict;
use ObjectTemplate;
use DateTime::Time;
use UserAgent;
use Url;

use vars qw(@ISA);
@ISA = qw(ObjectTemplate);


=head1 MEMBER VARIABLES

 uri               URI
 referer           HTTP referer
 remote_host       access host
 remote_host_short access host short format
 hua               HTTP_USER_AGENT
 id                TDSåID
 times             visit times
 counter           counter

=cut

attributes qw(uri referer time remote_host remote_host_short hua id times counter user_agent);

################################################################
sub initialize($)
{
    my $self = shift;
    $self->time(new DateTime::Time);

    $self->uri(new Url);
    $self->referer(new Url);
    $self->user_agent(new UserAgent);
    $self->SUPER::initialize;
}
################################################################
# return true:  if successed
# return false: illegal format
sub Set($$)
{
    my ($self, $line) = @_;

    my ($uri, $referer, $date_time, $remote_host, $hua, $id, $times, $counter)
	= split(/\t/, $line);
    # date
    $self->time->Set($date_time =~ m!(\d{4})/(\d{2})/(\d{2}) (\d{2}):(\d{2}):(\d{2}) *([A-Z]*)!o);
    unless ($self->time->IsValid){
	return 0;      # illegal data format
    }

    # attributes
    $self->uri->Set($uri);
    $self->referer->Set($referer);

    # remote host
    $self->remote_host($remote_host);

    my $short = $remote_host;
    # short remote_host:  foo.bar.com -> *.bar.comconvertation
    # thanks to KKI <kki-s@geocities.co.jp>
    if ($remote_host !~ /^[\d\.]+$/){    # IP address
	if ($remote_host =~ /.*\.(.*\..*\..*)$/ ||
	    $remote_host =~ /.*\.(.*\..*)$/      ||
	    $remote_host =~ /.*\.(.*)$/
	    ){
	    $short = "*.$1";
	}
    }
    $self->remote_host_short($short);
    $self->user_agent->Set($hua);
    if (1){
	$self->hua($self->user_agent->name_version);
    } else {
	$self->hua($self->user_agent->fullname);
    }
    $self->id($id), $self->times($times);
    $self->counter($counter);

    return 1;   # successed
}
################################################################
# static function
sub GetYmdByLine($)
{
    my $line = shift;
 
    my ($uri, $referer, $date_time, $remote_host, $hua, $id, $times, $counter)
	= split(/\t/, $line);
    # date
    $date_time =~ m!(\d{4})/(\d{2})/(\d{2})!;
    return ($1, $2, $3);
}



1;
