/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.CRAMEncodingStrategy;
import htsjdk.samtools.cram.structure.CompressionHeaderEncodingMap;
import htsjdk.samtools.cram.structure.EncodingDescriptor;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.cram.structure.block.BlockContentType;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompressionHeader {
    private static final String RN_readNamesIncluded = "RN";
    private static final String AP_alignmentPositionIsDelta = "AP";
    private static final String RR_referenceRequired = "RR";
    private static final String TD_tagIdsDictionary = "TD";
    private static final String SM_substitutionMatrix = "SM";
    private CompressionHeaderEncodingMap encodingMap;
    private boolean APDelta = true;
    private boolean preserveReadNames = true;
    private boolean referenceRequired = true;
    private final Map<Integer, EncodingDescriptor> tagEncodingMap = new TreeMap<Integer, EncodingDescriptor>();
    private SubstitutionMatrix substitutionMatrix;
    private byte[][][] tagIDDictionary;

    public CompressionHeader() {
        this.encodingMap = new CompressionHeaderEncodingMap(new CRAMEncodingStrategy());
    }

    public CompressionHeader(CompressionHeaderEncodingMap encodingMap, boolean isAPDelta, boolean isPreserveReadNames, boolean isReferenceRequired) {
        this.encodingMap = encodingMap;
        this.APDelta = isAPDelta;
        this.preserveReadNames = isPreserveReadNames;
        this.referenceRequired = isReferenceRequired;
    }

    public CompressionHeader(CompressionHeaderEncodingMap encodingMap) {
        this.encodingMap = encodingMap;
    }

    public CompressionHeader(CRAMVersion cramVersion, InputStream blockStream) {
        Block compressionHeaderBlock = Block.read(cramVersion, blockStream);
        if (compressionHeaderBlock.getContentType() != BlockContentType.COMPRESSION_HEADER) {
            throw new RuntimeIOException(String.format("Compression header block expected, found: %s", compressionHeaderBlock.getContentType().name()));
        }
        try (ByteArrayInputStream internalStream = new ByteArrayInputStream(compressionHeaderBlock.getRawContent());){
            this.internalRead(internalStream);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public CompressionHeaderEncodingMap getEncodingMap() {
        return this.encodingMap;
    }

    public void write(CRAMVersion cramVersion, OutputStream blockStream) {
        try (ByteArrayOutputStream internalOutputStream = new ByteArrayOutputStream();){
            this.internalWrite(internalOutputStream);
            Block block = Block.createRawCompressionHeaderBlock(internalOutputStream.toByteArray());
            block.write(cramVersion, blockStream);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public boolean isAPDelta() {
        return this.APDelta;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public Map<Integer, EncodingDescriptor> getTagEncodingMap() {
        return this.tagEncodingMap;
    }

    public SubstitutionMatrix getSubstitutionMatrix() {
        return this.substitutionMatrix;
    }

    public byte[][][] getTagIDDictionary() {
        return this.tagIDDictionary;
    }

    public void setTagIdDictionary(byte[][][] dictionary) {
        this.tagIDDictionary = dictionary;
    }

    public void setSubstitutionMatrix(SubstitutionMatrix substitutionMatrix) {
        this.substitutionMatrix = substitutionMatrix;
    }

    public boolean isReferenceRequired() {
        return this.referenceRequired;
    }

    public void addTagEncoding(int tagId, ExternalCompressor compressor, EncodingDescriptor params) {
        this.encodingMap.putTagBlockCompression(tagId, compressor);
        this.tagEncodingMap.put(tagId, params);
    }

    /*
     * WARNING - void declaration
     */
    private byte[][][] parseDictionary(byte[] bytes) {
        void var6_9;
        ArrayList dictionary = new ArrayList();
        for (int i = 0; i < bytes.length; ++i) {
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            while (bytes[i] != 0) {
                list.add(Arrays.copyOfRange(bytes, i, i + 3));
                i += 3;
            }
            dictionary.add(list);
        }
        int maxWidth = 0;
        for (List list : dictionary) {
            maxWidth = Math.max(maxWidth, list.size());
        }
        byte[][][] array = new byte[dictionary.size()][][];
        boolean bl = false;
        while (var6_9 < dictionary.size()) {
            List list = (List)dictionary.get((int)var6_9);
            array[var6_9] = (byte[][])list.toArray((T[])new byte[list.size()][]);
            ++var6_9;
        }
        return array;
    }

    private byte[] dictionaryToByteArray() {
        int size = 0;
        byte[][][] byArray = this.tagIDDictionary;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[][] dictionaryArrayArray;
            for (byte[] dictionaryArray : dictionaryArrayArray = byArray[i]) {
                size += dictionaryArray.length;
            }
            ++size;
        }
        byte[] bytes = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[][][] byArray2 = this.tagIDDictionary;
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            byte[][] dictionaryArrayArray;
            for (byte[] dictionaryArray : dictionaryArrayArray = byArray2[i]) {
                buffer.put(dictionaryArray);
            }
            buffer.put((byte)0);
        }
        return bytes;
    }

    private void internalRead(InputStream is) {
        int i;
        int byteSize = ITF8.readUnsignedITF8(is);
        byte[] bytes = new byte[byteSize];
        InputStreamUtils.readFully(is, bytes, 0, bytes.length);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int mapSize = ITF8.readUnsignedITF8(buffer);
        for (i = 0; i < mapSize; ++i) {
            String key = new String(new byte[]{buffer.get(), buffer.get()});
            if (RN_readNamesIncluded.equals(key)) {
                this.preserveReadNames = buffer.get() == 1;
                continue;
            }
            if (AP_alignmentPositionIsDelta.equals(key)) {
                this.APDelta = buffer.get() == 1;
                continue;
            }
            if (RR_referenceRequired.equals(key)) {
                this.referenceRequired = buffer.get() == 1;
                continue;
            }
            if (TD_tagIdsDictionary.equals(key)) {
                int size = ITF8.readUnsignedITF8(buffer);
                byte[] dictionaryBytes = new byte[size];
                buffer.get(dictionaryBytes);
                this.tagIDDictionary = this.parseDictionary(dictionaryBytes);
                continue;
            }
            if (SM_substitutionMatrix.equals(key)) {
                byte[] matrixBytes = new byte[SubstitutionMatrix.BASES_SIZE];
                buffer.get(matrixBytes);
                this.substitutionMatrix = new SubstitutionMatrix(matrixBytes);
                continue;
            }
            throw new RuntimeException("Unknown preservation map key: " + key);
        }
        if (this.substitutionMatrix == null || this.tagIDDictionary == null) {
            throw new CRAMException("substitution matrix and tag ID dictionary must be present in the compression header");
        }
        this.encodingMap = new CompressionHeaderEncodingMap(is);
        byteSize = ITF8.readUnsignedITF8(is);
        bytes = new byte[byteSize];
        InputStreamUtils.readFully(is, bytes, 0, bytes.length);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        mapSize = ITF8.readUnsignedITF8(buf);
        for (i = 0; i < mapSize; ++i) {
            int key = ITF8.readUnsignedITF8(buf);
            EncodingID id = EncodingID.values()[buf.get()];
            int paramLen = ITF8.readUnsignedITF8(buf);
            byte[] paramBytes = new byte[paramLen];
            buf.get(paramBytes);
            this.tagEncodingMap.put(key, new EncodingDescriptor(id, paramBytes));
        }
    }

    private void internalWrite(OutputStream outputStream) throws IOException {
        ByteBuffer mapBuffer = ByteBuffer.allocate(102400);
        ITF8.writeUnsignedITF8(5, mapBuffer);
        mapBuffer.put(RN_readNamesIncluded.getBytes());
        mapBuffer.put((byte)(this.preserveReadNames ? 1 : 0));
        mapBuffer.put(AP_alignmentPositionIsDelta.getBytes());
        mapBuffer.put((byte)(this.APDelta ? 1 : 0));
        mapBuffer.put(RR_referenceRequired.getBytes());
        mapBuffer.put((byte)(this.referenceRequired ? 1 : 0));
        mapBuffer.put(SM_substitutionMatrix.getBytes());
        mapBuffer.put(this.substitutionMatrix.getEncodedMatrix());
        mapBuffer.put(TD_tagIdsDictionary.getBytes());
        Object dictionaryBytes = this.dictionaryToByteArray();
        ITF8.writeUnsignedITF8(((byte[])dictionaryBytes).length, mapBuffer);
        mapBuffer.put((byte[])dictionaryBytes);
        mapBuffer.flip();
        byte[] mapBytes = new byte[mapBuffer.limit()];
        mapBuffer.get(mapBytes);
        ITF8.writeUnsignedITF8(mapBytes.length, outputStream);
        outputStream.write(mapBytes);
        this.encodingMap.write(outputStream);
        mapBuffer = ByteBuffer.allocate(102400);
        ITF8.writeUnsignedITF8(this.tagEncodingMap.size(), mapBuffer);
        dictionaryBytes = this.tagEncodingMap.keySet().iterator();
        while (dictionaryBytes.hasNext()) {
            Integer dataSeries = (Integer)dictionaryBytes.next();
            ITF8.writeUnsignedITF8((int)dataSeries, mapBuffer);
            EncodingDescriptor params = this.tagEncodingMap.get(dataSeries);
            mapBuffer.put((byte)(0xFF & params.getEncodingID().getId()));
            ITF8.writeUnsignedITF8(params.getEncodingParameters().length, mapBuffer);
            mapBuffer.put(params.getEncodingParameters());
        }
        mapBuffer.flip();
        byte[] mapBytes2 = new byte[mapBuffer.limit()];
        mapBuffer.get(mapBytes2);
        ITF8.writeUnsignedITF8(mapBytes2.length, outputStream);
        outputStream.write(mapBytes2);
    }
}

