require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_FFS_FS_H_)) {
    eval 'sub _UFS_FFS_FS_H_ () {1;}' unless defined(&_UFS_FFS_FS_H_);
    eval 'sub BBSIZE () {8192;}' unless defined(&BBSIZE);
    eval 'sub BBOFF () {(( &off_t)(0));}' unless defined(&BBOFF);
    eval 'sub BBLOCK () {(( &daddr_t)(0));}' unless defined(&BBLOCK);
    eval 'sub SBLOCK_FLOPPY () {0;}' unless defined(&SBLOCK_FLOPPY);
    eval 'sub SBLOCK_UFS1 () {8192;}' unless defined(&SBLOCK_UFS1);
    eval 'sub SBLOCK_UFS2 () {65536;}' unless defined(&SBLOCK_UFS2);
    eval 'sub SBLOCK_PIGGY () {262144;}' unless defined(&SBLOCK_PIGGY);
    eval 'sub SBLOCKSIZE () {8192;}' unless defined(&SBLOCKSIZE);
    eval 'sub SBLOCKSEARCH () {{  &SBLOCK_UFS2,  &SBLOCK_UFS1,  &SBLOCK_FLOPPY,  &SBLOCK_PIGGY, -1};}' unless defined(&SBLOCKSEARCH);
    eval 'sub MAXFRAG () {8;}' unless defined(&MAXFRAG);
    eval 'sub MINBSIZE () {4096;}' unless defined(&MINBSIZE);
    eval 'sub MAXMNTLEN () {468;}' unless defined(&MAXMNTLEN);
    eval 'sub MAXVOLLEN () {32;}' unless defined(&MAXVOLLEN);
    eval 'sub NOCSPTRS () {((128/ $sizeof{ &void }) - 4);}' unless defined(&NOCSPTRS);
    eval 'sub FS_MAXCONTIG () {16;}' unless defined(&FS_MAXCONTIG);
    eval 'sub FSMAXSNAP () {20;}' unless defined(&FSMAXSNAP);
    eval 'sub BLK_NOCOPY () {(( &daddr_t)(1));}' unless defined(&BLK_NOCOPY);
    eval 'sub BLK_SNAP () {(( &daddr_t)(2));}' unless defined(&BLK_SNAP);
    eval 'sub MINFREE () {5;}' unless defined(&MINFREE);
    eval 'sub DEFAULTOPT () { &FS_OPTTIME;}' unless defined(&DEFAULTOPT);
    eval 'sub AVFILESIZ () {16384;}' unless defined(&AVFILESIZ);
    eval 'sub AFPDIR () {64;}' unless defined(&AFPDIR);
    eval 'sub fs_old_postbloff () { $fs_spare5[0];}' unless defined(&fs_old_postbloff);
    eval 'sub fs_old_rotbloff () { $fs_spare5[1];}' unless defined(&fs_old_rotbloff);
    eval 'sub fs_old_postbl_start () { &fs_maxbsize;}' unless defined(&fs_old_postbl_start);
    eval 'sub fs_old_headswitch () { $fs_id[0];}' unless defined(&fs_old_headswitch);
    eval 'sub fs_old_trkseek () { $fs_id[1];}' unless defined(&fs_old_trkseek);
    eval 'sub fs_old_csmask () { $fs_spare1[0];}' unless defined(&fs_old_csmask);
    eval 'sub fs_old_csshift () { $fs_spare1[1];}' unless defined(&fs_old_csshift);
    eval 'sub FS_42POSTBLFMT () {-1;}' unless defined(&FS_42POSTBLFMT);
    eval 'sub FS_DYNAMICPOSTBLFMT () {1;}' unless defined(&FS_DYNAMICPOSTBLFMT);
    eval 'sub old_fs_postbl {
        my($fs_, $cylno, $opostblsave) = @_;
	    eval q((((($fs_)-> &fs_old_postblformat ==  &FS_42POSTBLFMT) || (($fs_)-> &fs_old_postbloff ==  &offsetof(\'struct fs\',  &fs_old_postbl_start))) ? (( &int16_t *)($opostblsave) + ($cylno) * ($fs_)-> &fs_old_nrpos) : (( &int16_t *)(( &uint8_t *)($fs_) + ($fs_)-> &fs_old_postbloff) + ($cylno) * ($fs_)-> &fs_old_nrpos)));
    }' unless defined(&old_fs_postbl);
    eval 'sub old_fs_rotbl {
        my($fs) = @_;
	    eval q(((($fs)-> &fs_old_postblformat ==  &FS_42POSTBLFMT) ? (( &uint8_t *)(($fs)-> &fs_magic+1)) : (( &uint8_t *)(( &uint8_t *)($fs) + ($fs)-> &fs_old_rotbloff))));
    }' unless defined(&old_fs_rotbl);
    eval 'sub FS_UFS1_MAGIC () {0x11954;}' unless defined(&FS_UFS1_MAGIC);
    eval 'sub FS_UFS2_MAGIC () {0x19540119;}' unless defined(&FS_UFS2_MAGIC);
    eval 'sub FS_UFS2EA_MAGIC () {0x19012038;}' unless defined(&FS_UFS2EA_MAGIC);
    eval 'sub FS_UFS1_MAGIC_SWAPPED () {0x54190100;}' unless defined(&FS_UFS1_MAGIC_SWAPPED);
    eval 'sub FS_UFS2_MAGIC_SWAPPED () {0x19015419;}' unless defined(&FS_UFS2_MAGIC_SWAPPED);
    eval 'sub FS_UFS2EA_MAGIC_SWAPPED () {0x38200119;}' unless defined(&FS_UFS2EA_MAGIC_SWAPPED);
    eval 'sub FS_OKAY () {0x7c269d38;}' unless defined(&FS_OKAY);
    eval 'sub FS_42INODEFMT () {-1;}' unless defined(&FS_42INODEFMT);
    eval 'sub FS_44INODEFMT () {2;}' unless defined(&FS_44INODEFMT);
    eval 'sub FS_ISCLEAN () {0x1;}' unless defined(&FS_ISCLEAN);
    eval 'sub FS_WASCLEAN () {0x2;}' unless defined(&FS_WASCLEAN);
    eval 'sub FS_OPTTIME () {0;}' unless defined(&FS_OPTTIME);
    eval 'sub FS_OPTSPACE () {1;}' unless defined(&FS_OPTSPACE);
    eval 'sub FS_UNCLEAN () {0x1;}' unless defined(&FS_UNCLEAN);
    eval 'sub FS_DOSOFTDEP () {0x2;}' unless defined(&FS_DOSOFTDEP);
    eval 'sub FS_NEEDSFSCK () {0x4;}' unless defined(&FS_NEEDSFSCK);
    eval 'sub FS_SUJ () {0x8;}' unless defined(&FS_SUJ);
    eval 'sub FS_POSIX1EACLS () {0x10;}' unless defined(&FS_POSIX1EACLS);
    eval 'sub FS_ACLS () { &FS_POSIX1EACLS;}' unless defined(&FS_ACLS);
    eval 'sub FS_MULTILABEL () {0x20;}' unless defined(&FS_MULTILABEL);
    eval 'sub FS_GJOURNAL () {0x40;}' unless defined(&FS_GJOURNAL);
    eval 'sub FS_FLAGS_UPDATED () {0x80;}' unless defined(&FS_FLAGS_UPDATED);
    eval 'sub FS_DOWAPBL () {0x100;}' unless defined(&FS_DOWAPBL);
    eval 'sub FS_DOQUOTA2 () {0x200;}' unless defined(&FS_DOQUOTA2);
    eval 'sub FS_TRIM () {0x400;}' unless defined(&FS_TRIM);
    eval 'sub FS_NFS4ACLS () {0x800;}' unless defined(&FS_NFS4ACLS);
    eval 'sub FS_KNOWN_FLAGS () {( &FS_DOSOFTDEP |  &FS_DOWAPBL |  &FS_DOQUOTA2 |  &FS_POSIX1EACLS |  &FS_NFS4ACLS);}' unless defined(&FS_KNOWN_FLAGS);
    eval 'sub FS_SWAPPED () {0x80000000;}' unless defined(&FS_SWAPPED);
    eval 'sub FS_INTERNAL () {0x80000000;}' unless defined(&FS_INTERNAL);
    eval 'sub ACTIVECG_SET {
        my($fs, $cg) = @_;
	    eval q( &do {  &if (($fs)-> &fs_active !=  &NULL)  &setbit(($fs)-> &fs_active, ($cg)); }  &while ( 0));
    }' unless defined(&ACTIVECG_SET);
    eval 'sub ACTIVECG_CLR {
        my($fs, $cg) = @_;
	    eval q( &do {  &if (($fs)-> &fs_active !=  &NULL)  &clrbit(($fs)-> &fs_active, ($cg)); }  &while ( 0));
    }' unless defined(&ACTIVECG_CLR);
    eval 'sub ACTIVECG_ISSET {
        my($fs, $cg) = @_;
	    eval q((($fs)-> &fs_active !=  &NULL  &&  &isset(($fs)-> &fs_active, ($cg))));
    }' unless defined(&ACTIVECG_ISSET);
    eval 'sub CGSIZE_IF {
        my($fs, $ipg, $fpg) = @_;
	    eval q(($sizeof{\'struct cg\'} + $sizeof{ &int32_t} + ($fs)-> &fs_old_cpg * $sizeof{ &int32_t} + ($fs)-> &fs_old_cpg * $sizeof{ &u_int16_t} +  &howmany(($ipg),  &NBBY) +  &howmany(($fpg),  &NBBY) + (($fs)-> &fs_contigsumsize <= 0? 0: ($fs)-> &fs_contigsumsize * $sizeof{ &int32_t} +  &howmany( &ffs_fragstoblks($fs, ($fpg)),  &NBBY))));
    }' unless defined(&CGSIZE_IF);
    eval 'sub CGSIZE {
        my($fs) = @_;
	    eval q( &CGSIZE_IF(($fs), ($fs)-> &fs_ipg, ($fs)-> &fs_fpg));
    }' unless defined(&CGSIZE);
    eval 'sub MINCYLGRPS () {4;}' unless defined(&MINCYLGRPS);
    eval 'sub fs_cs {
        my($fs, $indx) = @_;
	    eval q( $fs_csp[$indx]);
    }' unless defined(&fs_cs);
    eval 'sub CG_MAGIC () {0x90255;}' unless defined(&CG_MAGIC);
    eval 'sub old_cg_blktot_old {
        my($cgp, $ns) = @_;
	    eval q(((($cgp))-> &cg_btot));
    }' unless defined(&old_cg_blktot_old);
    eval 'sub old_cg_blks_old {
        my($fs, $cgp, $cylno, $ns) = @_;
	    eval q(((($cgp))-> $cg_b[$cylno]));
    }' unless defined(&old_cg_blks_old);
    eval 'sub old_cg_blktot_new {
        my($cgp, $ns) = @_;
	    eval q((( &int32_t *)(( &u_int8_t *)($cgp) +  &ufs_rw32(($cgp)-> &cg_old_btotoff, ($ns)))));
    }' unless defined(&old_cg_blktot_new);
    eval 'sub old_cg_blks_new {
        my($fs, $cgp, $cylno, $ns) = @_;
	    eval q((( &int16_t *)(( &u_int8_t *)($cgp) +  &ufs_rw32(($cgp)-> &cg_old_boff, ($ns))) + ($cylno) * ($fs)-> &fs_old_nrpos));
    }' unless defined(&old_cg_blks_new);
    eval 'sub old_cg_blktot {
        my($cgp, $ns) = @_;
	    eval q((( &ufs_rw32(($cgp)-> &cg_magic, ($ns)) !=  &CG_MAGIC) ?  &old_cg_blktot_old($cgp, $ns) :  &old_cg_blktot_new($cgp, $ns)));
    }' unless defined(&old_cg_blktot);
    eval 'sub old_cg_blks {
        my($fs, $cgp, $cylno, $ns) = @_;
	    eval q((( &ufs_rw32(($cgp)-> &cg_magic, ($ns)) !=  &CG_MAGIC) ?  &old_cg_blks_old($fs, $cgp, $cylno, $ns) :  &old_cg_blks_new($fs, $cgp, $cylno, $ns)));
    }' unless defined(&old_cg_blks);
    eval 'sub cg_inosused_new {
        my($cgp, $ns) = @_;
	    eval q((( &u_int8_t *)(( &u_int8_t *)($cgp) +  &ufs_rw32(($cgp)-> &cg_iusedoff, ($ns)))));
    }' unless defined(&cg_inosused_new);
    eval 'sub cg_blksfree_new {
        my($cgp, $ns) = @_;
	    eval q((( &u_int8_t *)(( &u_int8_t *)($cgp) +  &ufs_rw32(($cgp)-> &cg_freeoff, ($ns)))));
    }' unless defined(&cg_blksfree_new);
    eval 'sub cg_chkmagic_new {
        my($cgp, $ns) = @_;
	    eval q(( &ufs_rw32(($cgp)-> &cg_magic, ($ns)) ==  &CG_MAGIC));
    }' unless defined(&cg_chkmagic_new);
    eval 'sub cg_inosused_old {
        my($cgp, $ns) = @_;
	    eval q(((($cgp))-> &cg_iused));
    }' unless defined(&cg_inosused_old);
    eval 'sub cg_blksfree_old {
        my($cgp, $ns) = @_;
	    eval q(((($cgp))-> &cg_free));
    }' unless defined(&cg_blksfree_old);
    eval 'sub cg_chkmagic_old {
        my($cgp, $ns) = @_;
	    eval q(( &ufs_rw32((($cgp))-> &cg_magic, ($ns)) ==  &CG_MAGIC));
    }' unless defined(&cg_chkmagic_old);
    eval 'sub cg_inosused {
        my($cgp, $ns) = @_;
	    eval q((( &ufs_rw32(($cgp)-> &cg_magic, ($ns)) !=  &CG_MAGIC) ?  &cg_inosused_old($cgp, $ns) :  &cg_inosused_new($cgp, $ns)));
    }' unless defined(&cg_inosused);
    eval 'sub cg_blksfree {
        my($cgp, $ns) = @_;
	    eval q((( &ufs_rw32(($cgp)-> &cg_magic, ($ns)) !=  &CG_MAGIC) ?  &cg_blksfree_old($cgp, $ns) :  &cg_blksfree_new($cgp, $ns)));
    }' unless defined(&cg_blksfree);
    eval 'sub cg_chkmagic {
        my($cgp, $ns) = @_;
	    eval q(( &cg_chkmagic_new($cgp, $ns) ||  &cg_chkmagic_old($cgp, $ns)));
    }' unless defined(&cg_chkmagic);
    eval 'sub cg_clustersfree {
        my($cgp, $ns) = @_;
	    eval q((( &u_int8_t *)(( &u_int8_t *)($cgp) +  &ufs_rw32(($cgp)-> &cg_clusteroff, ($ns)))));
    }' unless defined(&cg_clustersfree);
    eval 'sub cg_clustersum {
        my($cgp, $ns) = @_;
	    eval q((( &int32_t *)(( &u_int8_t *)($cgp) +  &ufs_rw32(($cgp)-> &cg_clustersumoff, ($ns)))));
    }' unless defined(&cg_clustersum);
    if(defined (&_KERNEL)) {
	eval 'sub FFS_FSBTODB {
	    my($fs, $b) = @_;
    	    eval q((($b) << (($fs)-> &fs_fshift -  &DEV_BSHIFT)));
	}' unless defined(&FFS_FSBTODB);
	eval 'sub FFS_DBTOFSB {
	    my($fs, $b) = @_;
    	    eval q((($b) >> (($fs)-> &fs_fshift -  &DEV_BSHIFT)));
	}' unless defined(&FFS_DBTOFSB);
    } else {
	eval 'sub FFS_FSBTODB {
	    my($fs, $b) = @_;
    	    eval q((($b) << ($fs)-> &fs_fsbtodb));
	}' unless defined(&FFS_FSBTODB);
	eval 'sub FFS_DBTOFSB {
	    my($fs, $b) = @_;
    	    eval q((($b) >> ($fs)-> &fs_fsbtodb));
	}' unless defined(&FFS_DBTOFSB);
    }
    eval 'sub cgbase {
        my($fs, $c) = @_;
	    eval q(((( &daddr_t)($fs)-> &fs_fpg) * ($c)));
    }' unless defined(&cgbase);
    eval 'sub cgstart_ufs1 {
        my($fs, $c) = @_;
	    eval q(( &cgbase($fs, $c) + ($fs)-> &fs_old_cgoffset * (($c) & ~(($fs)-> &fs_old_cgmask))));
    }' unless defined(&cgstart_ufs1);
    eval 'sub cgstart_ufs2 {
        my($fs, $c) = @_;
	    eval q( &cgbase(($fs), ($c)));
    }' unless defined(&cgstart_ufs2);
    eval 'sub cgstart {
        my($fs, $c) = @_;
	    eval q((($fs)-> &fs_magic ==  &FS_UFS2_MAGIC ?  &cgstart_ufs2(($fs), ($c)) :  &cgstart_ufs1(($fs), ($c))));
    }' unless defined(&cgstart);
    eval 'sub cgdmin {
        my($fs, $c) = @_;
	    eval q(( &cgstart($fs, $c) + ($fs)-> &fs_dblkno));
    }' unless defined(&cgdmin);
    eval 'sub cgimin {
        my($fs, $c) = @_;
	    eval q(( &cgstart($fs, $c) + ($fs)-> &fs_iblkno));
    }' unless defined(&cgimin);
    eval 'sub cgsblock {
        my($fs, $c) = @_;
	    eval q(( &cgstart($fs, $c) + ($fs)-> &fs_sblkno));
    }' unless defined(&cgsblock);
    eval 'sub cgtod {
        my($fs, $c) = @_;
	    eval q(( &cgstart($fs, $c) + ($fs)-> &fs_cblkno));
    }' unless defined(&cgtod);
    eval 'sub ino_to_cg {
        my($fs, $x) = @_;
	    eval q(((( &ino_t)($x)) / ($fs)-> &fs_ipg));
    }' unless defined(&ino_to_cg);
    eval 'sub ino_to_fsba {
        my($fs, $x) = @_;
	    eval q((( &daddr_t)( &cgimin($fs,  &ino_to_cg($fs, ( &ino_t)($x))) + ( &ffs_blkstofrags(($fs), (((( &ino_t)($x)) % ($fs)-> &fs_ipg) /  &FFS_INOPB($fs)))))));
    }' unless defined(&ino_to_fsba);
    eval 'sub ino_to_fsbo {
        my($fs, $x) = @_;
	    eval q(((( &ino_t)($x)) %  &FFS_INOPB($fs)));
    }' unless defined(&ino_to_fsbo);
    eval 'sub dtog {
        my($fs, $d) = @_;
	    eval q((($d) / ($fs)-> &fs_fpg));
    }' unless defined(&dtog);
    eval 'sub dtogd {
        my($fs, $d) = @_;
	    eval q((($d) % ($fs)-> &fs_fpg));
    }' unless defined(&dtogd);
    eval 'sub blkmap {
        my($fs, $map, $loc) = @_;
	    eval q(((($map)[($loc) /  &NBBY] >> (($loc) %  &NBBY)) & (0xff >> ( &NBBY - ($fs)-> &fs_frag))));
    }' unless defined(&blkmap);
    eval 'sub old_cbtocylno {
        my($fs, $bno) = @_;
	    eval q(( &FFS_FSBTODB($fs, $bno) / ($fs)-> &fs_old_spc));
    }' unless defined(&old_cbtocylno);
    eval 'sub old_cbtorpos {
        my($fs, $bno) = @_;
	    eval q((($fs)-> &fs_old_nrpos <= 1? 0: ( &FFS_FSBTODB($fs, $bno) % ($fs)-> &fs_old_spc / ($fs)-> &fs_old_nsect * ($fs)-> &fs_old_trackskew +  &FFS_FSBTODB($fs, $bno) % ($fs)-> &fs_old_spc % ($fs)-> &fs_old_nsect * ($fs)-> &fs_old_interleave) % ($fs)-> &fs_old_nsect * ($fs)-> &fs_old_nrpos / ($fs)-> &fs_old_npsect));
    }' unless defined(&old_cbtorpos);
    eval 'sub ffs_blkoff {
        my($fs, $loc) = @_;
	    eval q((($loc) & ($fs)-> &fs_qbmask));
    }' unless defined(&ffs_blkoff);
    eval 'sub ffs_fragoff {
        my($fs, $loc) = @_;
	    eval q((($loc) & ($fs)-> &fs_qfmask));
    }' unless defined(&ffs_fragoff);
    eval 'sub ffs_lfragtosize {
        my($fs, $frag) = @_;
	    eval q(((( &off_t)($frag)) << ($fs)-> &fs_fshift));
    }' unless defined(&ffs_lfragtosize);
    eval 'sub ffs_lblktosize {
        my($fs, $blk) = @_;
	    eval q((( &uint64_t)((( &off_t)($blk)) << ($fs)-> &fs_bshift)));
    }' unless defined(&ffs_lblktosize);
    eval 'sub ffs_lblkno {
        my($fs, $loc) = @_;
	    eval q((($loc) >> ($fs)-> &fs_bshift));
    }' unless defined(&ffs_lblkno);
    eval 'sub ffs_numfrags {
        my($fs, $loc) = @_;
	    eval q((($loc) >> ($fs)-> &fs_fshift));
    }' unless defined(&ffs_numfrags);
    eval 'sub ffs_blkroundup {
        my($fs, $size) = @_;
	    eval q(((($size) + ($fs)-> &fs_qbmask) & ($fs)-> &fs_bmask));
    }' unless defined(&ffs_blkroundup);
    eval 'sub ffs_fragroundup {
        my($fs, $size) = @_;
	    eval q(((($size) + ($fs)-> &fs_qfmask) & ($fs)-> &fs_fmask));
    }' unless defined(&ffs_fragroundup);
    eval 'sub ffs_fragstoblks {
        my($fs, $frags) = @_;
	    eval q((($frags) >> ($fs)-> &fs_fragshift));
    }' unless defined(&ffs_fragstoblks);
    eval 'sub ffs_blkstofrags {
        my($fs, $blks) = @_;
	    eval q((($blks) << ($fs)-> &fs_fragshift));
    }' unless defined(&ffs_blkstofrags);
    eval 'sub ffs_fragnum {
        my($fs, $fsb) = @_;
	    eval q((($fsb) & (($fs)-> &fs_frag - 1)));
    }' unless defined(&ffs_fragnum);
    eval 'sub ffs_blknum {
        my($fs, $fsb) = @_;
	    eval q((($fsb) &~ (($fs)-> &fs_frag - 1)));
    }' unless defined(&ffs_blknum);
    eval 'sub ffs_getdb {
        my($fs, $ip, $lb) = @_;
	    eval q((($fs)-> &fs_magic ==  &FS_UFS2_MAGIC ? ( &daddr_t) &ufs_rw64(($ip)-> $i_ffs2_db[$lb],  &UFS_FSNEEDSWAP($fs)) : ( &daddr_t) &ufs_rw32(($ip)-> $i_ffs1_db[$lb],  &UFS_FSNEEDSWAP($fs))));
    }' unless defined(&ffs_getdb);
    eval 'sub ffs_getib {
        my($fs, $ip, $lb) = @_;
	    eval q((($fs)-> &fs_magic ==  &FS_UFS2_MAGIC ? ( &daddr_t) &ufs_rw64(($ip)-> $i_ffs2_ib[$lb],  &UFS_FSNEEDSWAP($fs)) : ( &daddr_t) &ufs_rw32(($ip)-> $i_ffs1_ib[$lb],  &UFS_FSNEEDSWAP($fs))));
    }' unless defined(&ffs_getib);
    eval 'sub freespace {
        my($fs, $percentreserved) = @_;
	    eval q(( &ffs_blkstofrags(($fs), ($fs)-> ($fs_cstotal->{cs_nbfree})) + ($fs)-> ($fs_cstotal->{cs_nffree}) - ((( &off_t)(($fs)-> &fs_dsize)) * ($percentreserved) / 100)));
    }' unless defined(&freespace);
    eval 'sub ffs_blksize {
        my($fs, $ip, $lbn) = @_;
	    eval q(((($lbn) >=  &UFS_NDADDR || ($ip)-> &i_size >=  &ffs_lblktosize($fs, ($lbn) + 1)) ? ($fs)-> &fs_bsize : (( &int32_t) &ffs_fragroundup($fs,  &ffs_blkoff($fs, ($ip)-> &i_size)))));
    }' unless defined(&ffs_blksize);
    eval 'sub ffs_sblksize {
        my($fs, $size, $lbn) = @_;
	    eval q(((($lbn) >=  &UFS_NDADDR || ($size) >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : (( &int32_t) &ffs_fragroundup($fs,  &ffs_blkoff($fs, ( &uint64_t)($size))))));
    }' unless defined(&ffs_sblksize);
    eval 'sub FFS_INOPB {
        my($fs) = @_;
	    eval q((($fs)-> &fs_inopb));
    }' unless defined(&FFS_INOPB);
    eval 'sub FFS_INOPF {
        my($fs) = @_;
	    eval q((($fs)-> &fs_inopb >> ($fs)-> &fs_fragshift));
    }' unless defined(&FFS_INOPF);
    eval 'sub FFS_NINDIR {
        my($fs) = @_;
	    eval q((($fs)-> &fs_nindir));
    }' unless defined(&FFS_NINDIR);
    eval 'sub APPLEUFS_LABEL_MAGIC () {0x4c41424c;}' unless defined(&APPLEUFS_LABEL_MAGIC);
    eval 'sub APPLEUFS_LABEL_SIZE () {1024;}' unless defined(&APPLEUFS_LABEL_SIZE);
    eval 'sub APPLEUFS_LABEL_OFFSET () {( &BBSIZE -  &APPLEUFS_LABEL_SIZE);}' unless defined(&APPLEUFS_LABEL_OFFSET);
    eval 'sub APPLEUFS_LABEL_VERSION () {1;}' unless defined(&APPLEUFS_LABEL_VERSION);
    eval 'sub APPLEUFS_MAX_LABEL_NAME () {512;}' unless defined(&APPLEUFS_MAX_LABEL_NAME);
}
1;
