/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.threading;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.usadellab.trimmomatic.TrimStats;
import org.usadellab.trimmomatic.threading.BlockOfRecords;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimStatsWorker
implements Runnable {
    private ArrayBlockingQueue<Future<BlockOfRecords>> logQueue;
    private AtomicBoolean complete;
    private TrimStats stats;

    public TrimStatsWorker(ArrayBlockingQueue<Future<BlockOfRecords>> logQueue) {
        this.logQueue = logQueue;
        this.complete = new AtomicBoolean();
        this.stats = new TrimStats();
    }

    public boolean isComplete() {
        return this.complete.get();
    }

    public TrimStats getStats() {
        return this.stats;
    }

    @Override
    public void run() {
        try {
            Future<BlockOfRecords> future = this.logQueue.take();
            BlockOfRecords bor = future.get();
            TrimStats st = bor.getStats();
            while (st != null) {
                this.stats.merge(st);
                future = this.logQueue.take();
                bor = future.get();
                st = bor.getStats();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.complete.set(true);
        }
    }
}

