/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.peer.MenuBarPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MenuBar
extends MenuComponent
implements MenuContainer,
Serializable,
Accessible {
    private static final long serialVersionUID = -4930327919388951260L;
    private Menu helpMenu;
    private Vector menus;
    private transient AccessibleContext accessibleContext;

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public synchronized void setHelpMenu(Menu menu) {
        if (this.helpMenu != null) {
            this.helpMenu.removeNotify();
            this.helpMenu.parent = null;
        }
        this.helpMenu = menu;
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        menu.parent = this;
        MenuBarPeer peer = (MenuBarPeer)this.getPeer();
        if (peer != null) {
            menu.addNotify();
            peer.addHelpMenu(menu);
        }
    }

    public synchronized Menu add(Menu menu) {
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        menu.parent = this;
        this.menus.addElement(menu);
        if (this.peer != null) {
            menu.addNotify();
        }
        return menu;
    }

    public synchronized void remove(int index) {
        Menu m = (Menu)this.menus.get(index);
        this.menus.remove(index);
        m.removeNotify();
        m.parent = null;
        if (this.peer != null) {
            MenuBarPeer mp = (MenuBarPeer)this.peer;
            mp.delMenu(index);
        }
    }

    public void remove(MenuComponent menu) {
        int index = this.menus.indexOf(menu);
        if (index == -1) {
            return;
        }
        this.remove(index);
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public int countMenus() {
        int n = this.menus.size();
        int n2 = 0;
        if (this.getHelpMenu() == null) {
            n2 = 1;
        }
        return n + (1 - n2);
    }

    public Menu getMenu(int index) {
        return (Menu)this.menus.elementAt(index);
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            this.setPeer(this.getToolkit().createMenuBar(this));
        }
        Enumeration e = this.menus.elements();
        while (e.hasMoreElements()) {
            Menu mi = (Menu)e.nextElement();
            mi.addNotify();
        }
        if (this.helpMenu != null) {
            this.helpMenu.addNotify();
            ((MenuBarPeer)this.peer).addHelpMenu(this.helpMenu);
        }
    }

    public void removeNotify() {
        Enumeration e = this.menus.elements();
        while (e.hasMoreElements()) {
            Menu mi = (Menu)e.nextElement();
            mi.removeNotify();
        }
        super.removeNotify();
    }

    public synchronized Enumeration shortcuts() {
        Vector shortcuts = new Vector();
        Enumeration e = this.menus.elements();
        while (e.hasMoreElements()) {
            Menu menu = (Menu)e.nextElement();
            if (menu.getShortcut() == null) continue;
            shortcuts.addElement(menu.getShortcut());
        }
        return shortcuts.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut shortcut) {
        Enumeration e = this.menus.elements();
        while (e.hasMoreElements()) {
            Menu menu = (Menu)e.nextElement();
            MenuShortcut s = menu.getShortcut();
            if (s == null || !s.equals(shortcut)) continue;
            return menu;
        }
        return null;
    }

    public void deleteShortcut(MenuShortcut shortcut) {
        MenuItem it;
        while ((it = this.getShortcutMenuItem(shortcut)) != null) {
            it.deleteShortcut();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar();
        }
        return this.accessibleContext;
    }

    private final /* synthetic */ void this() {
        this.menus = new Vector();
    }

    public MenuBar() {
        this.this();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        private static final long serialVersionUID = -8577604491830083815L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        protected AccessibleAWTMenuBar() {
        }
    }
}

