/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.html2.DomHTMLCollection;
import gnu.xml.dom.html2.DomHTMLDocument;
import gnu.xml.dom.html2.DomHTMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableRowElement;

public class DomHTMLTableRowElement
extends DomHTMLElement
implements HTMLTableRowElement {
    public int getRowIndex() {
        return this.getIndex();
    }

    public int getSectionRowIndex() {
        int index = 0;
        DomHTMLElement parent = (DomHTMLElement)this.getParentElement("table");
        if (parent != null) {
            Node tfoot;
            Node tbody;
            Node thead = parent.getChildElement("thead");
            if (thead != null) {
                Node ctx = thead.getFirstChild();
                while (ctx != null) {
                    if (ctx == this) {
                        return index;
                    }
                    ++index;
                    ctx = ctx.getNextSibling();
                }
            }
            if ((tbody = parent.getChildElement("tbody")) != null) {
                Node ctx = tbody.getFirstChild();
                while (ctx != null) {
                    if (ctx == this) {
                        return index;
                    }
                    ++index;
                    ctx = ctx.getNextSibling();
                }
            }
            if ((tfoot = parent.getChildElement("tfoot")) != null) {
                Node ctx = tfoot.getFirstChild();
                while (ctx != null) {
                    if (ctx == this) {
                        return index;
                    }
                    ++index;
                    ctx = ctx.getNextSibling();
                }
            }
        }
        throw new DomDOMException(8);
    }

    public HTMLCollection getCells() {
        DomHTMLCollection ret = new DomHTMLCollection((DomHTMLDocument)this.getOwnerDocument(), this);
        ret.addNodeName("th");
        ret.addNodeName("td");
        ret.evaluate();
        return ret;
    }

    public String getAlign() {
        return this.getHTMLAttribute("align");
    }

    public void setAlign(String align) {
        this.setHTMLAttribute("align", align);
    }

    public String getBgColor() {
        return this.getHTMLAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setHTMLAttribute("bgcolor", bgColor);
    }

    public String getCh() {
        return this.getHTMLAttribute("char");
    }

    public void setCh(String ch) {
        this.setHTMLAttribute("char", ch);
    }

    public String getChOff() {
        return this.getHTMLAttribute("charoff");
    }

    public void setChOff(String chOff) {
        this.setHTMLAttribute("charoff", chOff);
    }

    public String getVAlign() {
        return this.getHTMLAttribute("valign");
    }

    public void setVAlign(String vAlign) {
        this.setHTMLAttribute("valign", vAlign);
    }

    public HTMLElement insertCell(int index) {
        Node ref = this.getCell(index);
        Element cell = this.getOwnerDocument().createElement("td");
        if (ref == null) {
            this.appendChild(cell);
        } else {
            this.insertBefore(cell, ref);
        }
        return (HTMLElement)cell;
    }

    public void deleteCell(int index) {
        Node ref = this.getCell(index);
        if (ref == null) {
            throw new DomDOMException(1);
        }
        this.removeChild(ref);
    }

    Node getCell(int index) {
        int i = 0;
        Node ctx = this.getFirstChild();
        while (ctx != null) {
            String name = ctx.getLocalName();
            if (name == null) {
                name = ctx.getNodeName();
            }
            if ("td".equalsIgnoreCase(name) || "th".equalsIgnoreCase(name)) {
                if (index == i) {
                    return ctx;
                }
                ++i;
            }
            ctx = ctx.getNextSibling();
        }
        return null;
    }

    protected DomHTMLTableRowElement(DomHTMLDocument owner, String namespaceURI, String name) {
        super(owner, namespaceURI, name);
    }
}

