# NOTE: Derived from web_diary_dir/lib/DateTime/Zone.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package DateTime::Zone;

#line 235 "web_diary_dir/lib/DateTime/Zone.pm (autosplit into web_diary_dir/lib/auto/DateTime/Zone/tz_name.al)"
sub tz_name (;$$)
{
	my ($off, $dst) = @_;

	$off = tz_offset()
		unless(defined $off);

	my $dstNow = (localtime(time))[8];

	$dst = $dstNow
		unless(defined $dst);

	$off += ($dst ? 3600 : 0) - ($dstNow ? 3600 : 0);

	if (exists $dstZoneOff{$off} && ($dst || !exists $zoneOff{$off})) {
		return $dstZoneOff{$off};
	} elsif (exists $zoneOff{$off}) {
		return $zoneOff{$off};
	}
	sprintf("%+05d", int($off / 60) * 100 + $off % 60);
}

1;
1;
# end of DateTime::Zone::tz_name
