/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.filechooser.UnixFileSystemView;

public abstract class FileSystemView {
    private static FileSystemView defaultFileSystemView;

    public File createFileObject(File dir, String filename) {
        return new File(dir, filename);
    }

    public File createFileObject(String path) {
        return new File(path);
    }

    protected File createFileSystemRoot(File f) {
        File[] roots = File.listRoots();
        if (roots == null) {
            return null;
        }
        return roots[0];
    }

    public abstract File createNewFolder(File var1) throws IOException;

    public File getChild(File parent, String fileName) {
        return new File(parent, fileName);
    }

    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        if (dir == null || dir.listFiles() == null) {
            return null;
        }
        File[] files = dir.listFiles();
        if (!useFileHiding) {
            return files;
        }
        ArrayList trim = new ArrayList();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isHidden()) {
                trim.add(files[i]);
            }
            ++i;
        }
        File[] value = (File[])trim.toArray(new File[trim.size()]);
        return value;
    }

    public static FileSystemView getFileSystemView() {
        if (defaultFileSystemView == null && File.separator.equals("/")) {
            defaultFileSystemView = new UnixFileSystemView();
        }
        return defaultFileSystemView;
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getParentDirectory(File f) {
        if (f == null) {
            return null;
        }
        return f.getParentFile();
    }

    public File[] getRoots() {
        return null;
    }

    public String getSystemDisplayName(File f) {
        return null;
    }

    public Icon getSystemIcon(File f) {
        return null;
    }

    public String getSystemTypeDescription(File f) {
        return null;
    }

    public boolean isComputerNode(File dir) {
        return false;
    }

    public boolean isDrive(File dir) {
        return false;
    }

    public boolean isFileSystem(File f) {
        boolean bl = false;
        if (f.isFile() || f.isDirectory()) {
            bl = true;
        }
        return bl;
    }

    public boolean isFileSystemRoot(File dir) {
        File[] roots = File.listRoots();
        if (roots == null || dir == null) {
            return false;
        }
        String filename = dir.getAbsolutePath();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getAbsolutePath().equals(filename)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isFloppyDrive(File dir) {
        return false;
    }

    public boolean isHiddenFile(File f) {
        return f.isHidden();
    }

    public boolean isParent(File folder, File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        return folder.equals(parent);
    }

    public boolean isRoot(File f) {
        return false;
    }

    public Boolean isTraversable(File f) {
        return f.isDirectory();
    }
}

