/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_8
extends Charset {
    public final boolean contains(Charset cs) {
        boolean bl = false;
        if (cs instanceof US_ASCII || cs instanceof ISO_8859_1 || cs instanceof UTF_8 || cs instanceof UTF_16BE || cs instanceof UTF_16LE || cs instanceof UTF_16) {
            bl = true;
        }
        return bl;
    }

    public final CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public final CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    UTF_8() {
        super("UTF-8", new String[]{"ibm-1208", "ibm-1209", "ibm-5304", "ibm-5305", "windows-65001", "cp1208", "UTF8"});
    }

    private static final class Decoder
    extends CharsetDecoder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            CoderResult coderResult;
            int inPos = in.position();
            try {
                while (in.hasRemaining()) {
                    byte b1 = in.get();
                    int highNibble = (b1 & 0xFF) >> 4 & 0xF;
                    switch (highNibble) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (out.remaining() < 1) {
                                CoderResult coderResult2 = CoderResult.OVERFLOW;
                                Object var5_31 = null;
                                in.position(inPos);
                                return coderResult2;
                            }
                            out.put((char)b1);
                            ++inPos;
                            break;
                        }
                        case 12: 
                        case 13: {
                            if (in.remaining() < 1) {
                                CoderResult coderResult3 = CoderResult.UNDERFLOW;
                                Object var5_32 = null;
                                in.position(inPos);
                                return coderResult3;
                            }
                            if (out.remaining() < 1) {
                                CoderResult coderResult4 = CoderResult.OVERFLOW;
                                Object var5_33 = null;
                                in.position(inPos);
                                return coderResult4;
                            }
                            byte b2 = in.get();
                            if (!Decoder.isContinuation(b2)) {
                                CoderResult coderResult5 = CoderResult.malformedForLength(1);
                                Object var5_34 = null;
                                in.position(inPos);
                                return coderResult5;
                            }
                            char c = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                            if (c <= '\u007f') {
                                CoderResult coderResult6 = CoderResult.malformedForLength(2);
                                Object var5_35 = null;
                                in.position(inPos);
                                return coderResult6;
                            }
                            out.put(c);
                            inPos += 2;
                            break;
                        }
                        case 14: {
                            if (in.remaining() < 2) {
                                CoderResult coderResult7 = CoderResult.UNDERFLOW;
                                Object var5_36 = null;
                                in.position(inPos);
                                return coderResult7;
                            }
                            if (out.remaining() < 1) {
                                CoderResult coderResult8 = CoderResult.OVERFLOW;
                                Object var5_37 = null;
                                in.position(inPos);
                                return coderResult8;
                            }
                            byte b2 = in.get();
                            if (!Decoder.isContinuation(b2)) {
                                CoderResult coderResult9 = CoderResult.malformedForLength(1);
                                Object var5_38 = null;
                                in.position(inPos);
                                return coderResult9;
                            }
                            byte b3 = in.get();
                            if (!Decoder.isContinuation(b3)) {
                                CoderResult coderResult10 = CoderResult.malformedForLength(1);
                                Object var5_39 = null;
                                in.position(inPos);
                                return coderResult10;
                            }
                            char c = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                            if (c <= '\u07ff') {
                                CoderResult coderResult11 = CoderResult.malformedForLength(3);
                                Object var5_40 = null;
                                in.position(inPos);
                                return coderResult11;
                            }
                            out.put(c);
                            inPos += 3;
                            break;
                        }
                        case 15: {
                            if (in.remaining() < 3) {
                                CoderResult coderResult12 = CoderResult.UNDERFLOW;
                                Object var5_41 = null;
                                in.position(inPos);
                                return coderResult12;
                            }
                            if ((b1 & 0xF) > 4) {
                                CoderResult coderResult13 = CoderResult.malformedForLength(4);
                                Object var5_42 = null;
                                in.position(inPos);
                                return coderResult13;
                            }
                            if (out.remaining() < 2) {
                                CoderResult coderResult14 = CoderResult.OVERFLOW;
                                Object var5_43 = null;
                                in.position(inPos);
                                return coderResult14;
                            }
                            byte b2 = in.get();
                            if (!Decoder.isContinuation(b2)) {
                                CoderResult coderResult15 = CoderResult.malformedForLength(3);
                                Object var5_44 = null;
                                in.position(inPos);
                                return coderResult15;
                            }
                            byte b3 = in.get();
                            if (!Decoder.isContinuation(b3)) {
                                CoderResult coderResult16 = CoderResult.malformedForLength(2);
                                Object var5_45 = null;
                                in.position(inPos);
                                return coderResult16;
                            }
                            byte b4 = in.get();
                            if (!Decoder.isContinuation(b4)) {
                                CoderResult coderResult17 = CoderResult.malformedForLength(1);
                                Object var5_46 = null;
                                in.position(inPos);
                                return coderResult17;
                            }
                            int n = ((b1 & 3) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F) - 65536;
                            char c1 = (char)(0xD800 | (n & 0xFFC00) >> 10);
                            char c2 = (char)(0xDC00 | n & 0x3FF);
                            out.put(c1);
                            out.put(c2);
                            inPos += 4;
                            break;
                        }
                        default: {
                            CoderResult coderResult18 = CoderResult.malformedForLength(1);
                            Object var5_47 = null;
                            in.position(inPos);
                            return coderResult18;
                        }
                    }
                }
                coderResult = CoderResult.UNDERFLOW;
                Object var5_48 = null;
            }
            catch (Throwable throwable) {
                Object var5_49 = null;
                in.position(inPos);
                throw throwable;
            }
            in.position(inPos);
            return coderResult;
        }

        private static final boolean isContinuation(byte b) {
            boolean bl = false;
            if ((b & 0xC0) == 128) {
                bl = true;
            }
            return bl;
        }

        Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            CoderResult coderResult;
            int inPos;
            block17: {
                CoderResult coderResult2;
                block24: {
                    CoderResult coderResult3;
                    block23: {
                        CoderResult coderResult4;
                        block22: {
                            CoderResult coderResult5;
                            block21: {
                                CoderResult coderResult6;
                                block20: {
                                    CoderResult coderResult7;
                                    block19: {
                                        CoderResult coderResult8;
                                        inPos = in.position();
                                        try {
                                            while (true) {
                                                if (!in.hasRemaining()) {
                                                    coderResult = CoderResult.UNDERFLOW;
                                                    break block17;
                                                }
                                                int remaining = out.remaining();
                                                char c = in.get();
                                                if (c <= '\u007f') {
                                                    if (remaining < 1) {
                                                        coderResult8 = CoderResult.OVERFLOW;
                                                        Object var5_16 = null;
                                                        break;
                                                    } else {
                                                        out.put((byte)c);
                                                        ++inPos;
                                                        continue;
                                                    }
                                                }
                                                if (c <= '\u07ff') {
                                                    if (remaining < 2) {
                                                        coderResult7 = CoderResult.OVERFLOW;
                                                        break block19;
                                                    } else {
                                                        out.put((byte)(0xC0 | c >> 6));
                                                        out.put((byte)(0x80 | c & 0x3F));
                                                        ++inPos;
                                                        continue;
                                                    }
                                                }
                                                if ('\ud800' <= c && c <= '\udfff') {
                                                    if (remaining < 4) {
                                                        coderResult6 = CoderResult.OVERFLOW;
                                                        break block20;
                                                    }
                                                    if (c > '\udbff') {
                                                        coderResult5 = CoderResult.malformedForLength(1);
                                                        break block21;
                                                    }
                                                    if (!in.hasRemaining()) {
                                                        coderResult4 = CoderResult.UNDERFLOW;
                                                        break block22;
                                                    }
                                                    char d = in.get();
                                                    if (d < '\udc00' || d > '\udfff') {
                                                        coderResult3 = CoderResult.malformedForLength(1);
                                                        break block23;
                                                    } else {
                                                        int value = ((c & 0x3FF) << 10 | d & 0x3FF) + 65536;
                                                        out.put((byte)(0xF0 | value >> 18 & 7));
                                                        out.put((byte)(0x80 | value >> 12 & 0x3F));
                                                        out.put((byte)(0x80 | value >> 6 & 0x3F));
                                                        out.put((byte)(0x80 | value & 0x3F));
                                                        inPos += 2;
                                                        continue;
                                                    }
                                                }
                                                if (remaining < 3) {
                                                    coderResult2 = CoderResult.OVERFLOW;
                                                    break block24;
                                                }
                                                out.put((byte)(0xE0 | c >> 12));
                                                out.put((byte)(0x80 | c >> 6 & 0x3F));
                                                out.put((byte)(0x80 | c & 0x3F));
                                                ++inPos;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var5_24 = null;
                                            in.position(inPos);
                                            throw throwable;
                                        }
                                        in.position(inPos);
                                        return coderResult8;
                                    }
                                    Object var5_17 = null;
                                    in.position(inPos);
                                    return coderResult7;
                                }
                                Object var5_18 = null;
                                in.position(inPos);
                                return coderResult6;
                            }
                            Object var5_19 = null;
                            in.position(inPos);
                            return coderResult5;
                        }
                        Object var5_20 = null;
                        in.position(inPos);
                        return coderResult4;
                    }
                    Object var5_21 = null;
                    in.position(inPos);
                    return coderResult3;
                }
                Object var5_22 = null;
                in.position(inPos);
                return coderResult2;
            }
            Object var5_23 = null;
            in.position(inPos);
            return coderResult;
        }

        Encoder(Charset cs) {
            super(cs, 1.1f, 4);
        }
    }
}

