#
# must.rb
#
#   Copyright (c) 1999-2002 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#
#   $Id: must.rb,v 1.12 2002/01/05 06:19:34 aamine Exp $
#

class Object

  def must( *args )
    args.each {|c| return self if c === self }
    raise TypeError, "wrong arg type '#{type}' for required #{args.join('/')}"
  end

  def must_have( *args )
    args.each do |m|
      self.respond_to? m or
          raise ArgumentError, "receiver #{inspect} does not have '#{m}'"
    end
    self
  end

  alias needed must_have

  def must_be( obj )
    self == obj or
            raise ArgumentError, "expected #{eq.inspect} but is #{inspect}"
    self
  end

  def must_exist
    nil? and raise ArgumentError, 'receiver is wrongly nil'
  end

end
