/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.ClasspathTextLayoutPeer;
import gnu.java.awt.peer.gtk.GdkGraphics2D;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GdkTextLayout
implements ClasspathTextLayoutPeer {
    private final int native_state;
    private AttributedString attributedString;
    private FontRenderContext fontRenderContext;

    private final native void setText(String var1);

    private final native void getExtents(double[] var1, double[] var2);

    private final native void indexToPos(int var1, double[] var2);

    private final native void initState();

    private final native void dispose();

    static native void initStaticState();

    protected void finalize() {
        this.dispose();
    }

    public void draw(Graphics2D g2, float x, float y) {
        if (g2 instanceof GdkGraphics2D) {
            GdkGraphics2D gg2 = (GdkGraphics2D)g2;
            gg2.drawGdkTextLayout(this, x, y);
        } else {
            AttributedCharacterIterator ci = this.attributedString.getIterator();
            CharacterIteratorProxy proxy = new CharacterIteratorProxy(ci);
            Font defFont = g2.getFont();
            char c = ci.first();
            while (c != (char)-1) {
                proxy.begin = ci.getIndex();
                proxy.limit = ci.getRunLimit(TextAttribute.FONT);
                if (proxy.limit > proxy.begin) {
                    proxy.index = proxy.begin;
                    Object fnt = ci.getAttribute(TextAttribute.FONT);
                    GlyphVector gv = fnt instanceof Font ? ((Font)fnt).createGlyphVector(this.fontRenderContext, proxy) : defFont.createGlyphVector(this.fontRenderContext, proxy);
                    g2.drawGlyphVector(gv, x, y);
                    int n = gv.getNumGlyphs();
                    int i = 0;
                    while (i < n) {
                        GlyphMetrics gm = gv.getGlyphMetrics(i);
                        if (gm.getAdvanceX() == gm.getAdvance()) {
                            x += gm.getAdvanceX();
                        } else {
                            y += gm.getAdvanceY();
                        }
                        ++i;
                    }
                }
                c = ci.next();
            }
        }
    }

    public TextHitInfo getStrongCaret(TextHitInfo hit1, TextHitInfo hit2) {
        throw new Error("not implemented");
    }

    public byte getBaseline() {
        throw new Error("not implemented");
    }

    public boolean isLeftToRight() {
        throw new Error("not implemented");
    }

    public boolean isVertical() {
        throw new Error("not implemented");
    }

    public float getAdvance() {
        throw new Error("not implemented");
    }

    public float getAscent() {
        throw new Error("not implemented");
    }

    public float getDescent() {
        throw new Error("not implemented");
    }

    public float getLeading() {
        throw new Error("not implemented");
    }

    public int getCharacterCount() {
        throw new Error("not implemented");
    }

    public byte getCharacterLevel(int index) {
        throw new Error("not implemented");
    }

    public float[] getBaselineOffsets() {
        throw new Error("not implemented");
    }

    public Shape getBlackBoxBounds(int firstEndpoint, int secondEndpoint) {
        throw new Error("not implemented");
    }

    public Rectangle2D getBounds() {
        double[] inkExtents = new double[4];
        double[] logExtents = new double[4];
        this.getExtents(inkExtents, logExtents);
        return new Rectangle2D.Double(logExtents[0], logExtents[1], logExtents[2], logExtents[3]);
    }

    public float[] getCaretInfo(TextHitInfo hit, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public Shape getCaretShape(TextHitInfo hit, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds, TextLayout.CaretPolicy policy) {
        throw new Error("not implemented");
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint, Rectangle2D bounds) {
        AffineTransform at = new AffineTransform();
        GeneralPath gp = new GeneralPath();
        double[] rect = new double[4];
        Rectangle2D.Double tmp = new Rectangle2D.Double();
        int i = firstEndpoint;
        while (i <= secondEndpoint) {
            this.indexToPos(i, rect);
            ((Rectangle2D)tmp).setRect(rect[0], rect[1], rect[2], rect[3]);
            Rectangle2D.intersect(tmp, bounds, tmp);
            gp.append(tmp.getPathIterator(at), false);
            ++i;
        }
        return gp;
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextLeftHit(int offset, TextLayout.CaretPolicy policy) {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextRightHit(int offset, TextLayout.CaretPolicy policy) {
        throw new Error("not implemented");
    }

    public TextHitInfo hitTestChar(float x, float y, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo hit) {
        throw new Error("not implemented");
    }

    public float getVisibleAdvance() {
        throw new Error("not implemented");
    }

    public native Shape getOutline(AffineTransform var1);

    public Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint, Rectangle2D bounds) {
        throw new Error("not implemented");
    }

    public TextLayout getJustifiedLayout(float justificationWidth) {
        throw new Error("not implemented");
    }

    public void handleJustify(float justificationWidth) {
        throw new Error("not implemented");
    }

    public Object clone() {
        throw new Error("not implemented");
    }

    public int hashCode() {
        throw new Error("not implemented");
    }

    public boolean equals(ClasspathTextLayoutPeer tl) {
        throw new Error("not implemented");
    }

    public String toString() {
        throw new Error("not implemented");
    }

    private final /* synthetic */ void this() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
    }

    public GdkTextLayout(AttributedString str, FontRenderContext frc) {
        this.this();
        this.initState();
        this.attributedString = str;
        this.fontRenderContext = frc;
    }

    static {
        System.loadLibrary("gtkpeer");
        GdkTextLayout.initStaticState();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class CharacterIteratorProxy
    implements CharacterIterator {
        public CharacterIterator target;
        public int begin;
        public int limit;
        public int index;

        public int getBeginIndex() {
            return this.begin;
        }

        public int getEndIndex() {
            return this.limit;
        }

        public int getIndex() {
            return this.index;
        }

        public char setIndex(int idx) throws IllegalArgumentException {
            if (idx < this.begin || idx >= this.limit) {
                throw new IllegalArgumentException();
            }
            char ch = this.target.setIndex(idx);
            this.index = idx;
            return ch;
        }

        public char first() {
            int save = this.target.getIndex();
            char ch = this.target.setIndex(this.begin);
            this.target.setIndex(save);
            return ch;
        }

        public char last() {
            if (this.begin == this.limit) {
                return this.first();
            }
            int save = this.target.getIndex();
            char ch = this.target.setIndex(this.limit - 1);
            this.target.setIndex(save);
            return ch;
        }

        public char current() {
            return this.target.current();
        }

        public char next() {
            if (this.index >= this.limit - 1) {
                return (char)-1;
            }
            ++this.index;
            return this.target.next();
        }

        public char previous() {
            if (this.index <= this.begin) {
                return (char)-1;
            }
            --this.index;
            return this.target.previous();
        }

        public Object clone() {
            CharacterIteratorProxy cip = new CharacterIteratorProxy(this.target);
            cip.begin = this.begin;
            cip.limit = this.limit;
            cip.index = this.index;
            return cip;
        }

        public CharacterIteratorProxy(CharacterIterator ci) {
            this.target = ci;
        }
    }
}

