/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class AffineTransformOp
implements BufferedImageOp,
RasterOp {
    public static final int TYPE_NEAREST_NEIGHBOR = 1;
    public static final int TYPE_BILINEAR = 2;
    public static final int TYPE_BICUBIC = 3;
    private AffineTransform transform;
    private RenderingHints hints;

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, this.createCompatibleDestRaster(src.getRaster()), src.isAlphaPremultiplied(), null);
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        Rectangle rect = (Rectangle)this.getBounds2D(src);
        if (rect.getWidth() == 0.0 || rect.getHeight() == 0.0) {
            throw new RasterFormatException("width or height is 0");
        }
        return src.createCompatibleWritableRaster((int)rect.getWidth(), (int)rect.getHeight());
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == src) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, src.getColorModel());
        }
        Graphics2D gr = dst.createGraphics();
        gr.setRenderingHints(this.hints);
        gr.drawImage(src, this.transform, null);
        return dst;
    }

    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (dst == src) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        }
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("src and dst must have same number of bands");
        }
        double[] dpts = new double[dst.getWidth() * 2];
        double[] pts = new double[dst.getWidth() * 2];
        int x = 0;
        while (x < dst.getWidth()) {
            dpts[2 * x] = x + dst.getMinX();
            dpts[2 * x + 1] = x;
            ++x;
        }
        Rectangle srcbounds = src.getBounds();
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
            int y = dst.getMinY();
            while (y < dst.getMinY() + dst.getHeight()) {
                try {
                    this.transform.inverseTransform(dpts, 0, pts, 0, dst.getWidth() * 2);
                }
                catch (NoninvertibleTransformException e) {
                    e.printStackTrace();
                }
                int x2 = 0;
                while (x2 < dst.getWidth()) {
                    if (srcbounds.contains(pts[2 * x2], pts[2 * x2 + 1])) {
                        dst.setDataElements(x2 + dst.getMinX(), y, src.getDataElements((int)pts[2 * x2], (int)pts[2 * x2 + 1], null));
                    }
                    ++x2;
                }
                ++y;
            }
        } else if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            double[] tmp = new double[4 * src.getNumBands()];
            int y = dst.getMinY();
            while (y < dst.getMinY() + dst.getHeight()) {
                try {
                    this.transform.inverseTransform(dpts, 0, pts, 0, dst.getWidth() * 2);
                }
                catch (NoninvertibleTransformException e) {
                    e.printStackTrace();
                }
                int x3 = 0;
                while (x3 < dst.getWidth()) {
                    if (srcbounds.contains(pts[2 * x3], pts[2 * x3 + 1])) {
                        int xx = (int)pts[2 * x3];
                        int yy = (int)pts[2 * x3 + 1];
                        double dx = pts[2 * x3] - (double)xx;
                        double dy = pts[2 * x3 + 1] - (double)yy;
                        if (xx == src.getMinX() + src.getWidth() - 1 || yy == src.getMinY() + src.getHeight() - 1) {
                            Arrays.fill(tmp, 0.0);
                            src.getPixel(xx, yy, tmp);
                        } else {
                            src.getPixels(xx, yy, 2, 2, tmp);
                            int b = 0;
                            while (b < src.getNumBands()) {
                                tmp[b] = dx * dy * tmp[b] + (1.0 - dx) * dy * tmp[b + src.getNumBands()] + dx * (1.0 - dy) * tmp[b + 2 * src.getNumBands()] + (1.0 - dx) * (1.0 - dy) * tmp[b + 3 * src.getNumBands()];
                                ++b;
                            }
                        }
                        dst.setPixel(x3, y, tmp);
                    }
                    ++x3;
                }
                ++y;
            }
        } else {
            throw new UnsupportedOperationException("not implemented yet");
        }
        return dst;
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster src) {
        double x2 = (double)src.getWidth() + (double)src.getMinX();
        double y2 = (double)src.getHeight() + (double)src.getMinY();
        Point2D p2 = this.getPoint2D(new Point2D.Double(x2, y2), null);
        Rectangle rect = new Rectangle(0, 0, (int)p2.getX(), (int)p2.getY());
        return ((RectangularShape)rect).getBounds();
    }

    public final int getInterpolationType() {
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            return 2;
        }
        return 1;
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return this.transform.transform(srcPt, dstPt);
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final AffineTransform getTransform() {
        return this.transform;
    }

    public AffineTransformOp(AffineTransform xform, int interpolationType) {
        this.transform = xform;
        if (xform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
        switch (interpolationType) {
            case 2: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                break;
            }
            case 3: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                break;
            }
            default: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
        }
    }

    public AffineTransformOp(AffineTransform xform, RenderingHints hints) {
        this.transform = xform;
        this.hints = hints;
        if (xform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
    }
}

