/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.CharacterIterator;

public class Segment
implements Cloneable,
CharacterIterator {
    private boolean partialReturn;
    private int current;
    public char[] array;
    public int count;
    public int offset;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public char current() {
        if (this.count == 0 || this.current >= this.getEndIndex()) {
            return (char)-1;
        }
        return this.array[this.current];
    }

    public char first() {
        if (this.count == 0) {
            return (char)-1;
        }
        this.current = this.getBeginIndex();
        return this.array[this.current];
    }

    public int getBeginIndex() {
        return this.offset;
    }

    public int getEndIndex() {
        return this.offset + this.count;
    }

    public int getIndex() {
        return this.current;
    }

    public char last() {
        if (this.count == 0) {
            return (char)-1;
        }
        this.current = this.getEndIndex() - 1;
        return this.array[this.current];
    }

    public char next() {
        if (this.count == 0) {
            return (char)-1;
        }
        if (this.current + 1 >= this.getEndIndex()) {
            this.current = this.getEndIndex();
            return (char)-1;
        }
        ++this.current;
        return this.array[this.current];
    }

    public char previous() {
        if (this.count == 0 || this.current == this.getBeginIndex()) {
            return (char)-1;
        }
        --this.current;
        return this.array[this.current];
    }

    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.current = position;
        if (position == this.getEndIndex()) {
            return (char)-1;
        }
        return this.array[this.current];
    }

    public String toString() {
        return new String(this.array, this.offset, this.count);
    }

    public void setPartialReturn(boolean p) {
        this.partialReturn = p;
    }

    public boolean isPartialReturn() {
        return this.partialReturn;
    }

    public Segment() {
    }

    public Segment(char[] array, int offset, int count) {
        this.array = array;
        this.offset = offset;
        this.count = count;
    }
}

