/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Shape;
import java.awt.Stroke;
import java.util.Arrays;

public class BasicStroke
implements Stroke {
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private final float width;
    private final int cap;
    private final int join;
    private final float limit;
    private final float[] dash;
    private final float phase;

    public Shape createStrokedShape(Shape s) {
        throw new Error("not implemented");
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.limit;
    }

    public float[] getDashArray() {
        return this.dash;
    }

    public float getDashPhase() {
        return this.phase;
    }

    public int hashCode() {
        int hash = Float.floatToIntBits(this.width);
        hash ^= this.cap;
        hash ^= this.join;
        hash ^= Float.floatToIntBits(this.limit);
        if (this.dash != null) {
            int i = 0;
            while (i < this.dash.length) {
                hash ^= Float.floatToIntBits(this.dash[i]);
                ++i;
            }
        }
        return hash ^= Float.floatToIntBits(this.phase);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicStroke)) {
            return false;
        }
        BasicStroke s = (BasicStroke)o;
        boolean bl = false;
        if (this.width == s.width && this.cap == s.cap && this.join == s.join && this.limit == s.limit && Arrays.equals(this.dash, s.dash) && this.phase == s.phase) {
            bl = true;
        }
        return bl;
    }

    public BasicStroke(float width, int cap, int join, float miterlimit, float[] dash, float dashPhase) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("width " + width + " < 0");
        }
        if (cap < 0 || cap > 2) {
            throw new IllegalArgumentException("cap " + cap + " out of range [0..2]");
        }
        if (miterlimit < 1.0f && join == 0) {
            throw new IllegalArgumentException("miterlimit " + miterlimit + " < 1.0f while join == JOIN_MITER");
        }
        if (join < 0 || join > 2) {
            throw new IllegalArgumentException("join " + join + " out of range [0..2]");
        }
        if (dashPhase < 0.0f && dash != null) {
            throw new IllegalArgumentException("dashPhase " + dashPhase + " < 0.0f while dash != null");
        }
        if (dash != null) {
            if (dash.length == 0) {
                throw new IllegalArgumentException("dash.length is 0");
            }
            boolean allZero = true;
            int i = 0;
            while (i < dash.length) {
                if (dash[i] != 0.0f) {
                    allZero = false;
                    break;
                }
                ++i;
            }
            if (allZero) {
                throw new IllegalArgumentException("all dashes are 0.0f");
            }
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.limit = miterlimit;
        this.dash = dash == null ? null : (float[])dash.clone();
        this.phase = dashPhase;
    }

    public BasicStroke(float width, int cap, int join, float miterlimit) {
        this(width, cap, join, miterlimit, null, 0.0f);
    }

    public BasicStroke(float width, int cap, int join) {
        this(width, cap, join, 10.0f, null, 0.0f);
    }

    public BasicStroke(float width) {
        this(width, 2, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }
}

