/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ConvolveOp
implements BufferedImageOp,
RasterOp {
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    private Kernel kernel;
    private int edge;
    private RenderingHints hints;

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == dst) {
            throw new IllegalArgumentException();
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, src.getColorModel());
        }
        BufferedImage src1 = src;
        if (!src.isPremultiplied) {
            src1 = this.createCompatibleDestImage(src, src.getColorModel());
            src.copyData(src1.getRaster());
            src1.coerceData(true);
        }
        BufferedImage dst1 = dst;
        if (!src.getColorModel().equals(dst.getColorModel())) {
            dst1 = this.createCompatibleDestImage(src, src.getColorModel());
        }
        this.filter(src1.getRaster(), dst1.getRaster());
        if (dst1 != dst) {
            Graphics2D gg = dst.createGraphics();
            gg.setRenderingHints(this.hints);
            gg.drawImage((Image)dst1, 0, 0, null);
            gg.dispose();
        }
        return dst;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        return new BufferedImage(dstCM, src.getRaster().createCompatibleWritableRaster(), src.isPremultiplied, null);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public int getEdgeCondition() {
        return this.edge;
    }

    public Kernel getKernel() {
        return (Kernel)this.kernel.clone();
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (src == dest) {
            throw new IllegalArgumentException();
        }
        if (src.getWidth() < this.kernel.getWidth() || src.getHeight() < this.kernel.getHeight()) {
            throw new ImagingOpException(null);
        }
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else if (src.numBands != dest.numBands) {
            throw new ImagingOpException(null);
        }
        if (this.edge == 0) {
            float[] zeros = new float[src.getNumBands() * src.getWidth() * (this.kernel.getYOrigin() - 1)];
            Arrays.fill(zeros, 0.0f);
            dest.setPixels(src.getMinX(), src.getMinY(), src.getWidth(), this.kernel.getYOrigin() - 1, zeros);
        } else {
            float[] vals = new float[src.getNumBands() * src.getWidth() * (this.kernel.getYOrigin() - 1)];
            src.getPixels(src.getMinX(), src.getMinY(), src.getWidth(), this.kernel.getYOrigin() - 1, vals);
            dest.setPixels(src.getMinX(), src.getMinY(), src.getWidth(), this.kernel.getYOrigin() - 1, vals);
        }
        float[] kvals = this.kernel.getKernelData(null);
        float[] tmp = new float[this.kernel.getWidth() * this.kernel.getHeight()];
        int y = src.getMinY() + this.kernel.getYOrigin();
        while (y < src.getMinY() + src.getHeight() - this.kernel.getYOrigin() / 2) {
            float[] t1 = new float[(this.kernel.getXOrigin() - 1) * src.getNumBands()];
            if (this.edge == 0) {
                Arrays.fill(t1, 0.0f);
            } else {
                src.getPixels(src.getMinX(), y, this.kernel.getXOrigin() - 1, 1, t1);
            }
            dest.setPixels(src.getMinX(), y, this.kernel.getXOrigin() - 1, 1, t1);
            int x = src.getMinX();
            while (x < src.getWidth() + src.getMinX()) {
                int b = 0;
                while (b < src.getNumBands()) {
                    float v = 0.0f;
                    src.getSamples(x, y, this.kernel.getWidth(), this.kernel.getHeight(), b, tmp);
                    int i = 0;
                    while (i < tmp.length) {
                        v += tmp[i] * kvals[i];
                        ++i;
                    }
                    dest.setSample(x, y, b, v);
                    ++b;
                }
                ++x;
            }
            float[] t2 = new float[this.kernel.getWidth() / 2 * src.getNumBands()];
            if (this.edge == 0) {
                Arrays.fill(t2, 0.0f);
            } else {
                src.getPixels(src.getMinX() + src.getWidth() - this.kernel.getWidth() / 2, y, this.kernel.getWidth() / 2, 1, t2);
            }
            dest.setPixels(src.getMinX() + src.getWidth() - this.kernel.getWidth() / 2, y, this.kernel.getWidth() / 2, 1, t2);
            ++y;
        }
        y = src.getMinY();
        while (y < src.getHeight() + src.getMinY()) {
            int x = src.getMinX();
            while (x < src.getWidth() + src.getMinX()) {
                ++x;
            }
            ++y;
        }
        y = src.getMinY();
        while (y < src.getHeight() + src.getMinY()) {
            int x = src.getMinX();
            while (x < src.getWidth() + src.getMinX()) {
                ++x;
            }
            ++y;
        }
        if (this.edge == 0) {
            float[] zeros = new float[src.getNumBands() * src.getWidth() * (this.kernel.getHeight() / 2)];
            Arrays.fill(zeros, 0.0f);
            dest.setPixels(src.getMinX(), src.getHeight() + src.getMinY() - this.kernel.getHeight() / 2, src.getWidth(), this.kernel.getHeight() / 2, zeros);
        } else {
            float[] vals = new float[src.getNumBands() * src.getWidth() * (this.kernel.getHeight() / 2)];
            src.getPixels(src.getMinX(), src.getHeight() + src.getMinY() - this.kernel.getHeight() / 2, src.getWidth(), this.kernel.getHeight() / 2, vals);
            dest.setPixels(src.getMinX(), src.getHeight() + src.getMinY() - this.kernel.getHeight() / 2, src.getWidth(), this.kernel.getHeight() / 2, vals);
        }
        return dest;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }

    public ConvolveOp(Kernel kernel, int edgeCondition, RenderingHints hints) {
        this.kernel = kernel;
        this.edge = edgeCondition;
        this.hints = hints;
    }

    public ConvolveOp(Kernel kernel) {
        this.kernel = kernel;
        this.edge = 0;
        this.hints = null;
    }
}

