/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.stat;

public class ZScoreCalculator {
    private boolean statsReady;
    private double mean;
    private double sumX;
    private double N;
    private double sumXSquared;
    private float stdDev;
    private double min;
    private double max;

    public ZScoreCalculator() {
        this.reset();
    }

    public void observe(double x) {
        this.sumX += x;
        this.sumXSquared += x * x;
        this.N += 1.0;
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
    }

    public final void calculateStats() {
        if (this.statsReady) {
            return;
        }
        assert (this.N != 0.0) : "You must call observe at least once before calculating statistics.";
        this.mean = this.sumX / this.N;
        this.stdDev = (float)Math.sqrt(this.sumXSquared / this.N - this.mean * this.mean);
        this.statsReady = true;
    }

    public double zScore(double x) {
        return this.zScore(x, false);
    }

    public double zScore(double x, boolean useMinimumAsMean) {
        assert (this.statsReady) : "Statistics must have been calculated before this method is called";
        if (useMinimumAsMean) {
            return (x - this.min) / (double)this.stdDev;
        }
        return (x - this.mean) / (double)this.stdDev;
    }

    public double stdDev() {
        assert (this.statsReady) : "Statistics must have been calculated before this method is called";
        return this.stdDev;
    }

    public double mean() {
        assert (this.statsReady) : "Statistics must have been calculated before this method is called";
        return this.mean;
    }

    public double sum() {
        return this.sumX;
    }

    public double count() {
        return this.N;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public void reset() {
        this.N = 0.0;
        this.mean = 0.0;
        this.sumX = 0.0;
        this.sumXSquared = 0.0;
        this.statsReady = false;
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
    }
}

