/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.structure.AlignmentContext;

public class AlignmentSpan {
    private final int alignmentStart;
    private final int alignmentSpan;
    private final int mappedCount;
    private final int unmappedCount;
    private final int unmappedUnplacedCount;

    public AlignmentSpan(AlignmentContext alignmentContext, int mappedCount, int unmappedCount, int unmappedUnplacedCount) {
        this.alignmentStart = alignmentContext.getAlignmentStart();
        this.alignmentSpan = alignmentContext.getAlignmentSpan();
        this.mappedCount = mappedCount;
        this.unmappedCount = unmappedCount;
        this.unmappedUnplacedCount = unmappedUnplacedCount;
    }

    public AlignmentSpan(int alignmentStart, int alignmentSpan, int mappedCount, int unmappedCount, int unmappedUnplacedCount) {
        this.alignmentStart = alignmentStart;
        this.alignmentSpan = alignmentSpan;
        this.mappedCount = mappedCount;
        this.unmappedCount = unmappedCount;
        this.unmappedUnplacedCount = unmappedUnplacedCount;
    }

    public static AlignmentSpan combine(AlignmentSpan a, AlignmentSpan b) {
        int start = Math.min(a.getAlignmentStart(), b.getAlignmentStart());
        int span = a.getAlignmentStart() == b.getAlignmentStart() ? Math.max(a.getAlignmentSpan(), b.getAlignmentSpan()) : Math.max(a.getAlignmentStart() + a.getAlignmentSpan(), b.getAlignmentStart() + b.getAlignmentSpan()) - start;
        int mappedCount = a.mappedCount + b.mappedCount;
        int unmappedCount = a.unmappedCount + b.unmappedCount;
        int unmappedUnplacedCount = a.unmappedUnplacedCount + b.unmappedUnplacedCount;
        return new AlignmentSpan(start, span, mappedCount, unmappedCount, unmappedUnplacedCount);
    }

    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public int getAlignmentSpan() {
        return this.alignmentSpan;
    }

    public int getMappedCount() {
        return this.mappedCount;
    }

    public int getUnmappedCount() {
        return this.unmappedCount;
    }

    public int getUnmappedUnplacedCount() {
        return this.unmappedUnplacedCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlignmentSpan that = (AlignmentSpan)o;
        if (this.getAlignmentStart() != that.getAlignmentStart()) {
            return false;
        }
        if (this.getAlignmentSpan() != that.getAlignmentSpan()) {
            return false;
        }
        if (this.getMappedCount() != that.getMappedCount()) {
            return false;
        }
        if (this.getUnmappedCount() != that.getUnmappedCount()) {
            return false;
        }
        return this.getUnmappedUnplacedCount() == that.getUnmappedUnplacedCount();
    }

    public int hashCode() {
        int result = this.getAlignmentStart();
        result = 31 * result + this.getAlignmentSpan();
        result = 31 * result + this.getMappedCount();
        result = 31 * result + this.getUnmappedCount();
        result = 31 * result + this.getUnmappedUnplacedCount();
        return result;
    }
}

