/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.compression;

import it.unimi.dsi.io.InputBitStream;
import java.io.IOException;
import org.campagnelab.goby.compression.FastArithmeticDecoderI;

public final class FastArithmeticDecoder
implements FastArithmeticDecoderI {
    public static final int BITS = 63;
    private static final long HALF = 0x4000000000000000L;
    private static final long QUARTER = 0x2000000000000000L;
    private final int[] count;
    private int total;
    private final int n;
    private long range = 0x4000000000000000L;
    private long buffer = -1L;
    private long window = 0L;
    private boolean useBinarySearch = true;
    private int maxIndexNonZeroFrequency = Integer.MIN_VALUE;
    private int lastCount;
    private int lastIndex = -1;

    @Override
    public void reset() {
        this.window = 0L;
        this.buffer = -1L;
        this.range = 0x4000000000000000L;
    }

    public FastArithmeticDecoder(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("You cannot use " + n + " symbols.");
        }
        this.n = n;
        this.count = new int[n + 1];
        for (int i = 0; i < n; ++i) {
            this.incrementCount(i);
        }
        this.total = n;
    }

    private void incrementCount(int x) {
        ++x;
        while (x <= this.n) {
            int n = x;
            this.count[n] = this.count[n] + 1;
            x += x & -x;
        }
    }

    private int getCount(int x) {
        if (x == this.lastIndex) {
            return this.lastCount;
        }
        int c = 0;
        int xArg = x;
        while (x != 0) {
            c += this.count[x];
            x &= x - 1;
        }
        return c;
    }

    private int findXBinary(int x, int start, int end) {
        if (end == start) {
            return start - 1;
        }
        int middle = (start + end) / 2;
        int count = this.getCount(middle);
        if (x < count) {
            return this.findXBinary(x, start, middle);
        }
        if (x > count) {
            return this.findXBinary(x, middle + 1, end);
        }
        this.lastCount = count;
        this.lastIndex = middle;
        return middle;
    }

    @Override
    public int decode(InputBitStream ibs) throws IOException {
        long r;
        int x;
        if (this.buffer == -1L) {
            this.window = this.buffer = ibs.readLong(62);
        }
        if (this.total - 1 < (x = (int)(this.buffer / (r = this.range / (long)this.total)))) {
            x = this.total - 1;
        }
        int v = x;
        x = this.findXBinary(v, 1, this.n);
        int lowCount = this.getCount(x);
        int highCount = this.getCount(x + 1);
        this.lastIndex = -1;
        long l = r * (long)lowCount;
        this.buffer -= l;
        this.range = x != this.n - 1 ? r * (long)(highCount - lowCount) : (this.range -= l);
        this.incrementCount(x);
        ++this.total;
        while (this.range <= 0x2000000000000000L) {
            this.buffer <<= 1;
            this.range <<= 1;
            this.window <<= 1;
            if (ibs.readBit() == 0) continue;
            ++this.buffer;
            ++this.window;
        }
        return x;
    }

    @Override
    public void flush(InputBitStream ibs) throws IOException {
        long roundup;
        long bits;
        long value;
        int nbits;
        long low = (this.window & 0x3FFFFFFFFFFFFFFFL) + 0x4000000000000000L - this.buffer;
        for (nbits = 1; nbits <= 63 && (low > (value = (bits = low + (roundup = (1L << 63 - nbits) - 1L) >>> 63 - nbits) << 63 - nbits) || value + roundup > low + (this.range - 1L) && (value + roundup < 0L || low + (this.range - 1L) >= 0L)); ++nbits) {
        }
        for (int i = 1; i <= nbits; ++i) {
            this.window <<= 1;
            this.window |= (long)ibs.readBit();
        }
    }

    @Override
    public long getWindow() {
        return this.window & Long.MAX_VALUE;
    }

    @Override
    public void reposition(InputBitStream input) throws IOException {
        this.flush(input);
        long position = input.readBits() - 63L;
        input.flush();
        input.position(position);
        input.readBits(position);
    }
}

