#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ñ᤿ե륯饹 (FreePWING::Word, 
# FreePWING::EndWord) Τδ첾ۥ饹
#
package FreePWING::BaseWord;

require 5.005;
require Exporter;
use FileHandle;
use English;
use FreePWING::CharConv;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $max_word_length
	    $word_direction
	    $endword_direction);

@ISA = qw(Exporter);

#
# ñκĹ
#
$max_word_length = 255;

#
# ñν񤭹
#
$word_direction = 1;
$endword_direction = -1;

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ñեΥϥɥ
	'handle' => FileHandle->new(),

	# ñե̾
	'file_name' => '',

	# ޤǤ˽񤭹ȥ
	'entry_count' => 0,

	# ñν񤭹 ($word_direction  $endword_direction)
	'direction' => $word_direction,

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name)
#           file_name
#		ñե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽å
# :
# 	񤭹Ѥñե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name) = @ARG;

    #
    # ñե򳫤
    #
    $self->{'file_name'} = $file_name;
    if (!$self->{'handle'}->open($self->{'file_name'}, 'w')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ñեĤ롣ƤʤС⤷ʤ
# :
#	 1 ֤
#
sub close {
    my $self = shift;

    $self->close_internal();
    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#       close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;

    if ($self->{'handle'}->fileno()) {
	$self->{'handle'}->close();
    }
}

#
# :
#	add_entry(word, heading_position, heading_file_name,
#		  text_position, text_file_name)
#           word
#		ñ
#           heading_position
# 		Фΰ
#           heading_file_name
# 		ФΥե̾
#           text_position
# 		ʸΰ
#           text_file_name
# 		ʸΥե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ñեñɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry {
    my $self = shift;
    my ($word, $heading_position, $heading_file_name, $text_position,
	$text_file_name) = @ARG;

    #
    # ñ롣
    #
    my @unpacked_word = unpack('C*', $word);
    my $fixed_word = '';

    my $i = 0;
    while ($i < scalar(@unpacked_word)) {
	my $c0 = $unpacked_word[$i];
	if ($c0 == 0x20 || $c0 == 0x27 || $c0 == 0x2d) {
	    #
	    # ` ', `\'', `-' Ϻ
	    #
	    $i++;
	} elsif (0x21 <= $c0 && $c0 <= 0x7e) {
            #
            # US-ASCII  JIS X 0208 ѴƵϿ
	    # ˡѾʸʸѴƵϿ
            #
	    if (0x61 <= $c0 && $c0 <= 0x7a) {
		$c0 -= 0x20;
	    }
            $fixed_word .= $ascii_to_jisx0208_table->[$c0 - 0x20];
            $i++;

	} elsif (0xa1 <= $c0 && $c0 <= 0xfe) {
            #
            # JIS X 0208 ʸ...
            #
            my $c1 = $unpacked_word[$i + 1];
            if (!defined($c1) || $c1 < 0xa1 || 0xfe < $c1) {
                $self->{'error_message'} =
		    sprintf("invalid character: \\x%02x", $c0);
		$self->close_internal();
                return 0;
            }

	    if ($c0 == 0xa3 && 0xc1 <= $c1 && $c1 <= 0xda) {
		#
		# ѾʸʸѴƵϿ
		#
		$fixed_word .= pack("CC", $c0 & 0x7f, ($c1 - 0x20) & 0x7f);
	    } elsif ($c0 == 0xa1 && ($c1 == 0xa1 || $c1 == 0xc7 || $c1 == 0xdd
				     || $c1 == 0xa6 || $c1 == 0xbe)) {
		#
		# `', `', `', `', `' Ϻ
		#
	    } else {
		#
		# ʳϤΤޤ޵Ͽ
		#
		$fixed_word .= pack("CC", $c0 & 0x7f, $c1 & 0x7f);
	    }
	    $i += 2;

	} elsif ($c0 == 0x8e) {
            #
            # SS2 Ѥ JIS X 0201 ʤ JIS X 0208 ʤѴƵϿ
            #
            my $c1 = $unpacked_word[$i + 1];
            if (!defined($c1) || $c1 < 0xa1 || 0xfe < $c1) {
		$self->{'error_message'} =
		    sprintf("invalid character: \\x%02x", $c0);
		$self->close_internal();
                return 0;
            }
	    $fixed_word .= $jisx0201_to_jisx0208_table->[$c1 - 0xa0];
	    $i += 2;
	} else {
	    $self->{'error_message'} =
		sprintf("invalid character: \\x%02x", $c0);
	    $self->close_internal();
	    return 0;
	}
    }

    #
    # ñĹå롣
    #
    if (length($fixed_word) == 0) {
	$self->{'error_message'} = "word is empty";
	$self->close_internal();
	return 0;
    }
    if (255 < length($fixed_word)) {
	$self->{'error_message'} = "too long word";
	$self->close_internal();
	return 0;
    }

    #
    # ǥåä顢ñҤä֤
    #
    if ($self->{'direction'} == $endword_direction) {
	$fixed_word = pack("n*", reverse(unpack("n*", $fixed_word)));
    }

    #
    # ñ쥨ȥեؽ񤭹ࡣ
    #
    if (!$self->{'handle'}
	->printf("%s\t%08x\t%s\t%08x\t%s\n", $fixed_word, $heading_position,
		 $heading_file_name, $text_position, $text_file_name)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    $self->{'entry_count'}++;

    #
    # ñ˥ʤޤޤƤϡҤ餬ʤľ
    #
    my @unpacked_fixed_word = unpack('C*', $fixed_word);
    my $katakana_flag = 0;
    my $i = 0;
    while ($i < scalar(@unpacked_fixed_word)) {
	if ($unpacked_fixed_word[$i] == 0x25) {
	    $unpacked_fixed_word[$i] = 0x24;
	    $katakana_flag = 1;
	}
	$i += 2;
    }

    #
    # ñ˴ޤޤƤʤҤ餬ʤľϡľ
    # ȥ碌ƽ񤭹ࡣ
    #
    if ($katakana_flag) {
	$fixed_word = pack("C*", @unpacked_fixed_word);
	if (!$self->{'handle'}
	    ->printf("%s\t%08x\t%s\t%08x\t%s\n", $fixed_word,
		     $heading_position, $heading_file_name, $text_position,
		     $text_file_name)) {
	    $self->{'error_message'} =
		"failed to write the file, $ERRNO: " . $self->{'file_name'};
	    $self->close_internal();
	    return 0;
	}
	$self->{'entry_count'}++;
    }

    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
