/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 4325555698756477346L;
    public static final int ALWAYS_UPDATE = 2;
    public static final int NEVER_UPDATE = 1;
    public static final int UPDATE_WHEN_ON_EDT = 0;
    int policy;
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    DocumentListener documentListener;
    PropertyChangeListener propertyChangeListener;
    private JTextComponent textComponent;
    private boolean selectionVisible;
    private int blinkRate;
    private int dot;
    private int mark;
    private Point magicCaretPosition;
    private boolean visible;
    private Object highlightEntry;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public void setUpdatePolicy(int policy) {
        if (policy != 2 && policy != 1 && policy != 0) {
            throw new IllegalArgumentException("policy must be ALWAYS_UPDATE, NEVER__UPDATE, or UPDATE_WHEN_ON_EDT");
        }
        this.policy = policy;
    }

    public int getUpdatePolicy() {
        return this.policy;
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.getButton() != 1) {
            return;
        }
        this.setDot(this.textComponent.viewToModel(event.getPoint()));
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
    }

    protected void moveCaret(MouseEvent event) {
    }

    protected void positionCaret(MouseEvent event) {
    }

    public void deinstall(JTextComponent c) {
        this.textComponent.removeFocusListener(this);
        this.textComponent.removeMouseListener(this);
        this.textComponent.removeMouseMotionListener(this);
        this.textComponent.getDocument().removeDocumentListener(this.documentListener);
        this.documentListener = null;
        this.textComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.textComponent = null;
    }

    public void install(JTextComponent c) {
        this.textComponent = c;
        this.textComponent.addFocusListener(this);
        this.textComponent.addMouseListener(this);
        this.textComponent.addMouseMotionListener(this);
        this.propertyChangeListener = new PropertyChangeHandler();
        this.textComponent.addPropertyChangeListener(this.propertyChangeListener);
        this.documentListener = new DocumentHandler();
        this.textComponent.getDocument().addDocumentListener(this.documentListener);
        this.repaint();
    }

    public void setMagicCaretPosition(Point p) {
        this.magicCaretPosition = p;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public int getMark() {
        return this.mark;
    }

    private final void handleHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        int p0 = Math.min(this.dot, this.mark);
        int p1 = Math.max(this.dot, this.mark);
        if (this.selectionVisible && p0 != p1) {
            try {
                if (this.highlightEntry == null) {
                    this.highlightEntry = highlighter.addHighlight(p0, p1, this.getSelectionPainter());
                }
                highlighter.changeHighlight(this.highlightEntry, p0, p1);
            }
            catch (BadLocationException e) {
                throw new InternalError();
            }
        } else if (this.highlightEntry != null) {
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    public void setSelectionVisible(boolean v) {
        if (this.selectionVisible == v) {
            return;
        }
        this.selectionVisible = v;
        this.handleHighlight();
        this.repaint();
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    protected final void repaint() {
        this.textComponent.repaint(this);
    }

    public void paint(Graphics g) {
        if (this.textComponent == null) {
            return;
        }
        int dot = this.getDot();
        Rectangle rect = null;
        try {
            rect = this.textComponent.modelToView(dot);
        }
        catch (BadLocationException e) {
            return;
        }
        if (rect == null) {
            return;
        }
        if (this.visible) {
            g.setColor(this.textComponent.getCaretColor());
            g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void addChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultCaret.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultCaret.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultCaret.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.getListeners(clazz);
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].stateChanged(this.changeEvent);
            ++index;
        }
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public int getBlinkRate() {
        return this.blinkRate;
    }

    public void setBlinkRate(int rate) {
        this.blinkRate = rate;
    }

    public int getDot() {
        return this.dot;
    }

    public void moveDot(int dot) {
        this.dot = dot;
        this.handleHighlight();
        this.repaint();
    }

    public void setDot(int dot) {
        this.dot = dot;
        this.mark = dot;
        this.handleHighlight();
        this.repaint();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        if (v != this.visible) {
            this.visible = v;
            this.repaint();
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.policy = 0;
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectionVisible = true;
        this.blinkRate = 500;
        this.dot = 0;
        this.mark = 0;
        this.magicCaretPosition = null;
        this.visible = true;
    }

    public DefaultCaret() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("document")) {
                Document oldDoc = (Document)e.getOldValue();
                oldDoc.removeDocumentListener(DefaultCaret.this.documentListener);
                Document newDoc = (Document)e.getNewValue();
                newDoc.addDocumentListener(DefaultCaret.this.documentListener);
            }
        }

        private PropertyChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DocumentHandler
    implements DocumentListener {
        public void changedUpdate(DocumentEvent event) {
        }

        public void insertUpdate(DocumentEvent event) {
            if (DefaultCaret.this.policy == 2 || SwingUtilities.isEventDispatchThread() && DefaultCaret.this.policy == 0) {
                int dot = DefaultCaret.this.getDot();
                DefaultCaret.this.setDot(dot + event.getLength());
            }
        }

        public void removeUpdate(DocumentEvent event) {
            if (DefaultCaret.this.policy == 2 || SwingUtilities.isEventDispatchThread() && DefaultCaret.this.policy == 0) {
                int dot = DefaultCaret.this.getDot();
                DefaultCaret.this.setDot(dot - event.getLength());
            } else if (DefaultCaret.this.policy == 1) {
                int docLength = event.getDocument().getLength();
                if (DefaultCaret.this.getDot() > docLength) {
                    DefaultCaret.this.setDot(docLength);
                }
            }
        }

        private DocumentHandler() {
        }
    }
}

