/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j;

import ch.systemsx.cisd.args4j.Argument;
import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.Option;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Starter {
    public static final String PARAMETER_NAME = "mainclass";

    public static void main(String[] args) {
        String classname = System.getProperty(PARAMETER_NAME);
        CmdLineParser parser = null;
        boolean classHasArgument = false;
        boolean classHasOptions = false;
        if (classname == null || "".equals(classname)) {
            System.err.println("The system property 'mainclass' must contain the classname to start.");
            System.exit(-1);
        }
        try {
            Method m;
            Class<?> clazz = Class.forName(classname);
            Object bean = clazz.newInstance();
            parser = new CmdLineParser(bean);
            classHasArgument = Starter.hasAnnotation(clazz, Argument.class);
            classHasOptions = Starter.hasAnnotation(clazz, Option.class);
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException ex) {
                System.err.println(ex.getMessage());
                System.err.print(classname);
                if (classHasOptions) {
                    System.err.print(" [options]");
                }
                if (classHasArgument) {
                    System.err.print(" arguments");
                }
                System.err.println();
                parser.printUsage(System.err);
            }
            boolean couldInvoke = false;
            try {
                m = clazz.getMethod("run", null);
                m.invoke(bean, null);
                couldInvoke = true;
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            if (!couldInvoke) {
                try {
                    m = clazz.getMethod("run", String[].class);
                    m.invoke(bean, new Object[]{args});
                    couldInvoke = true;
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cant find the class '" + classname + "' as specified in the system property '" + PARAMETER_NAME + "'.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean hasAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (clazz.getAnnotation(annotation) != null) {
            return true;
        }
        AccessibleObject[] accessibleObjectArray = clazz.getFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = accessibleObjectArray[n2];
            if (f.getAnnotation(annotation) != null) {
                return true;
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject m = accessibleObjectArray[n2];
            if (((Method)m).getAnnotation(annotation) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

