# -*- encoding: utf-8 -*-
# stub: loquacious 1.9.1 ruby lib

Gem::Specification.new do |s|
  s.name = "loquacious".freeze
  s.version = "1.9.1".freeze

  s.required_rubygems_version = Gem::Requirement.new(">= 0".freeze) if s.respond_to? :required_rubygems_version=
  s.require_paths = ["lib".freeze]
  s.authors = ["Tim Pease".freeze]
  s.date = "2011-12-16"
  s.description = "Descriptive configuration files for Ruby written in Ruby.\n\nLoquacious provides a very open configuration system written in ruby and\ndescriptions for each configuration attribute. The attributes and descriptions\ncan be iterated over allowing for helpful information about those attributes to\nbe displayed to the user.\n\nIn the simple case we have a file something like\n\n  Loquacious.configuration_for('app') {\n    name 'value', :desc => \"Defines the name\"\n    foo  'bar',   :desc => \"FooBar\"\n    id   42,      :desc => \"Ara T. Howard\"\n  }\n\nWhich can be loaded via the standard Ruby loading mechanisms\n\n  Kernel.load 'config/app.rb'\n\nThe attributes and their descriptions can be printed by using a Help object\n\n  help = Loquacious.help_for('app')\n  help.show :values => true        # show the values for the attributes, too\n\nDescriptions are optional, and configurations can be nested arbitrarily deep.\n\n  Loquacious.configuration_for('nested') {\n    desc \"The outermost level\"\n    a {\n      desc \"One more level in\"\n      b {\n        desc \"Finally, a real value\"\n        c 'value'\n      }\n    }\n  }\n\n  config = Loquacious.configuration_for('nested')\n\n  p config.a.b.c  #=> \"value\"\n\nAnd as you can see, descriptions can either be given inline after the value or\nthey can appear above the attribute and value on their own line.".freeze
  s.email = "tim.pease@gmail.com".freeze
  s.extra_rdoc_files = ["History.txt".freeze, "README.rdoc".freeze]
  s.files = ["History.txt".freeze, "README.rdoc".freeze]
  s.homepage = "http://rubygems.org/gems/loquacious".freeze
  s.rdoc_options = ["--main".freeze, "README.rdoc".freeze]
  s.rubygems_version = "3.6.9".freeze
  s.summary = "Descriptive configuration files for Ruby written in Ruby.".freeze

  s.installed_by_version = "3.6.9".freeze

  s.specification_version = 3

  s.add_development_dependency(%q<rspec>.freeze, ["~> 2.6".freeze])
end
