/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalButtonListener;

public class MetalButtonUI
extends BasicButtonUI {
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalButtonUI();
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        if (button.isRolloverEnabled() && button.getBorder() instanceof UIResource) {
            button.setBorder(MetalBorders.getRolloverBorder());
        }
    }

    public void uninstallDefaults(AbstractButton button) {
        super.uninstallDefaults(button);
        if (button.getBorder() instanceof UIResource) {
            button.setBorder(null);
        }
    }

    protected BasicButtonListener createButtonListener(AbstractButton button) {
        return new MetalButtonListener(button);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Rectangle area = b.getVisibleRect();
            g.setColor(this.selectColor);
            g.fillRect(area.x, area.y, area.width, area.height);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.hasFocus() && b.isFocusPainted()) {
            Color savedColor = g.getColor();
            g.setColor(this.getFocusColor());
            Rectangle focusRect = iconRect.union(textRect);
            g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
            g.setColor(savedColor);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        Font f = b.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (b.isEnabled()) {
            g.setColor(b.getForeground());
            g.drawString(text, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(this.getDisabledTextColor());
            g.drawString(text, textRect.x, textRect.y + fm.getAscent());
        }
    }

    public MetalButtonUI() {
        UIDefaults def = UIManager.getLookAndFeelDefaults();
        this.focusColor = def.getColor(this.getPropertyPrefix() + "focus");
        this.selectColor = def.getColor(this.getPropertyPrefix() + "select");
        this.disabledTextColor = def.getColor(this.getPropertyPrefix() + "disabledText");
    }
}

