package TDS::Collection;
# $Id: Collection.pm,v 1.76 2000/12/20 14:59:33 tom Exp $
################################################################

=head1 NAME

TDS::Collection - Tdf Set

=head1 SYNOPSIS

 use TDS::Collection;
 use TDS::Status;

 $status = new TDS::Status;
 $c = new TDS::Collection
 $c->Read;
 print $c->AsHTML({});

=head1 DESCRIPTION

ꥯȤˤɤ߹٤ե򽸤ᡢɤ߹ߡѡ
ưִ⤳ǹԤ


빽ʣǤ
$status->mode, $status->year,month,day,part ʤɤ׵ᤵ줿
ФϤޤ

 ɤ߹ߡ    
 Read(;$lm):
  collect_files():
   status->mode ˽ pickup_*
     pickup_files($y,$m,$d,$min,$max):
     pickup_recent($y,$m,$d,$num)
     pickup_neighbour($y,$m,$d,$p,$n)
       Ϳ줿󽸹֤ [$path,$y,$m,$d,$lm]
   pickup_*() 󽸹֤
  󽸹򸵤˥եɤ߹ߡϤ
   read_files(@files)
    @files γƥեɤ߹ߡϤ
      parse_file($filename, $parser);
	$filename ɤߡparse
  ɤ߹ե֤

 ɽ
 AsHTML($params)
   ٤ƤˤĤ AsHTML
   ưִ

=cut

################################################################

use strict;

use JConv;
use ObjectTemplate;
use DateTime::Date;
use DateTime::Format;
use CGI::QueryString;

use TDS;
use TDS::System;
use TDS::DirInfo;

#BEGIN { warn times, " Collection start"; }

use vars qw(@ISA $AUTOLOAD
	    $RecentNum $NeighbourNum $AutoReplace
	    $ReverseInRecent $AllowAllMonthly
	    $TdfJcode);
@ISA = qw(ObjectTemplate);

=head1 STATIC VARIABLES

 $RecentNum       ɽ
 $NeighbourNum    ˵ɽ
 $AutoReplace     ưִ򤹤뤫
 $TdfJcode        δ
 $AllowAllMonthly   

=cut

$RecentNum = 5 unless defined $RecentNum;
$NeighbourNum = 0 unless defined $NeighbourNum;
$AutoReplace = 1 unless defined $AutoReplace;
$TdfJcode = '' unless defined $TdfJcode;
$ReverseInRecent = 0 unless defined $ReverseInRecent;
$AllowAllMonthly = 1 unless defined $AllowAllMonthly;

=head1 MEMBER VARIABLES

 diary          ֥TDS::Tdf::Parser ν
 last_modified  κٺǽ
 replacer_url   ִ֥
 replacer_term
 replacer_dictionary

=cut

attributes qw(diarys last_modified
	      replacer_url replacer_term replacer_dictionary
	      files last_day);

################################################################
# auto loading

use AutoLoader;

sub AUTOLOAD {
    $AutoLoader::AUTOLOAD = $AUTOLOAD;
    goto &AutoLoader::AUTOLOAD;
}

package TDS::Collection;
1;

################################################################
__END__

=head1 MEMBER FUNCTIONS

=cut

sub initialize($)
{
    my $self = shift;

    $self->ClearDiarys();
    $self->SUPER::initialize;
}

################################################################

=head2 $c->Read($lm);

$status λ̤ɤ٤ tdf 򽸤ᡢΥեɤ
ɤ߹ե֤
ɤ߹٤ե뤬Ĥ̵ -1 ֤

$lm Ȥ tm Ϥȡ
꿷ե

=cut

sub Read ($;$)
{
    my ($self, $lm) = @_;

    my @files = $self->collect_files;

    return -1 if @files == 0;
    unless ($lm){                # λʤ
	return scalar($self->read_files(@files));
    } else {
#	print "set: $lm, tdf: " . $self->last_modified . "\n";
	if ($self->last_modified > $lm){ # ꤵ줿꿷
	    return  scalar($self->read_files(@files));
	} else {                         # 줿̵
	    return 0;
	}
    }
}
# ɤ߹(diarys)򥯥ꥢ
sub ClearDiarys ($)
{
    my $self = shift;

    $self->diarys([]);
    $self->files([]);
    $self->last_modified(0);
}
sub GetMonthDirs($;$)
{
    my ($self, $spec_year) = @_;

    my @dirs;

    my $nowym = sprintf("%04d%02d",
			$TDS::Status->start_time->year,
			$TDS::Status->start_time->month);
			
    my $diary_dir = GetDiaryDir();
    opendir(Y_DIR, $diary_dir) || die $diary_dir;
#    while ($_ = readdir(Y_DIR)){
    for (reverse sort readdir(Y_DIR)){
	next unless /^\d{4}$/ && -d "$diary_dir/$_";
	my $year = $_;
	next if ($spec_year && $year != $spec_year);
	opendir(M_DIR, "$diary_dir/$year") || die "$diary_dir/$year";
#	while ($_ = readdir(M_DIR)){
	for (reverse sort readdir(M_DIR)){
	    next unless /^\d{2}$/ && -d "$diary_dir/$year/$_";
	    next if $nowym lt "$year/$_";    # ̤ϥå
	    push(@dirs, [$year, $_]);
	}
	closedir M_DIR;
    }
    closedir Y_DIR;

    return @dirs;
}
################################################################

=head2 $c->collect_files

ɤ߹ tdf ե򽸤ᡢ
ɤ߹٤ @files ֤

ö᤿顢$self->files ˥åȤƳǼ
Ϥ򤽤Τޤ֤

=cut

sub collect_files ($;$)
{
    my ($self, $mode) = shift;

    # ե륭å֤
    return @{$self->files} if @{$self->files};

    $mode ||= $TDS::Status->mode;
#    die $mode;
    my @files;
    if ($mode eq 'RECENT'){
	@files = 
	    $self->pickup_recent($TDS::Status->start_time->year, 
				 $TDS::Status->start_time->month,
				 $TDS::Status->start_time->day,
				 $RecentNum);
    } elsif ($mode eq 'N_YEAR'){
	for ($TDS::Status->start_year..
	     $TDS::Status->year){
	    my $year = $_;
	    push(@files,
		 $self->pickup_neighbour($year,
					 $TDS::Status->month,
					 $TDS::Status->day_part));

	}
    } elsif ($mode eq 'PSEUDO_RECENT'){
	@files = $self->pickup_recent($TDS::Status->year,
				      $TDS::Status->month,
				      $TDS::Status->day_part,
				      $RecentNum);
    } else {
	my $day_part = $TDS::Status->day_part;

	if ($day_part eq ''){           # 
	    @files = $self->pickup_files($TDS::Status->year,
					 $TDS::Status->month);
	} elsif ($day_part =~ /[abc]/){ # 
	    my ($min_day, $max_day) =
		($day_part eq 'a') ? (1, 9) :
		    ($day_part eq 'b') ? (10, 19) :
			(20, 31);
	    @files = $self->pickup_files($TDS::Status->year,
					 $TDS::Status->month,
					 $min_day, $max_day);
	} else {                        # 
	    my $num = $NeighbourNum;
	    @files = $self->pickup_neighbour($TDS::Status->year,
					     $TDS::Status->month,
					     $TDS::Status->day_part,
					     $num, $num);
	}
    }
    if (@files){
	my $day = new DateTime::Date;
	$day->Set(@{$files[scalar(@files)-1]}[1,2,3]);
	$self->last_day($day);
#	die $day->Dump;
    }
    return @{$self->files} = @files;
}
################################################################

=head2 $c->pickup_files($year, $month, $min_day, $max_day);

$year/$month  $min_day  $max_day ޤǤФ
[ѥ̾, ǯ, , , ] Υǡʤ֤

=cut

sub pickup_files($$$$$)
{
    my ($self, $year, $month, $min_day, $max_day) = @_;

    $month = sprintf("%02d", $month);

    #print STDERR caller;
    my $dir = GetDiaryDir() . "/$year/$month";
    opendir(DIR, $dir) || return ();
    my @files;
    for (sort readdir(DIR)){
#    for (($rvs)? reverse sort readdir(DIR) : sort readdir(DIR)){
	my $file = $_;
	my $d;
	next unless $file =~ /^(\d\d)\.tdf$/;    # must be DD.tdf
	$d = $1;
	next unless ($d >= 1 && $d <= DaysMonth($year, $month)); # valid date
	next if -z "$dir/$file";                    # must be not empty
	#print "$file, ";
	my $flg;
	if ($min_day == 0){    # monthly
	    $flg = 1;
	} else {               # day or partly
	    $flg = ($d >= $min_day && $d <= $max_day);
	}
	if ($flg){
	    my $lm = (stat("$dir/$file"))[9];
	    if ($self->last_modified < $lm){
		$self->last_modified($lm);
	    }
	    push(@files, ["$dir/$file", $year, $month, $d, $lm]);
	}
    }
    closedir(DIR);

    return @files;
}

=head2 $c->pickup_recent($year, $month, $day, $num);

ǿ $num Ф
$num == 0 ʤ

=cut

sub pickup_recent($$$$$)
{
    my ($self, $year, $month, $day, $num) = @_;
    my $date = new DateTime::Date(year=>$year, month=>$month, day=>$day);
    
    my @files;

    while ($date->year >= $TDS::Status->start_year && # ¸ߤǯ
	   ($num <= 0 ||                                    # 礬ꤵƤʤ
	    (@files < $num))){                         # ꤵ줿ʬ
	#print STDERR "collect_files\n";
	push(@files, reverse $self->pickup_files($date->year, $date->month, 1, $day));
	$date -= '1M';
	$day = 31;
    }
    # ɬפΤʤե last_modified ⸫ƤΤǡ
    # ⤦Ĵ
    my $lm;
    # ɽꤵƤʤä
    unless ($num){
	$num = $#files+1;
    }
    # եɽ礭äեˡʾ
    if ($num > $#files+1){
	$num = $#files+1;
    }
    # lm å
    for (@files[0..$num-1]){
	my $the_lm = $_->[4] || 0;
	if ($lm < $the_lm){
	    $lm = $the_lm;
	}
    }
    $self->last_modified($lm);
    #  @files ֤
    # print STDERR "collect_files done\n";
    return @files[0..$num-1];
}

=head2 $c->pickup_neighbour($year, $month, $day, $prev_num, $next_num);

$year/$month/$day ն [$prev_num, $next_num] ʬФ

=cut

sub pickup_neighbour ($$$$$$)
{
    my ($self, $year, $month, $day, $prev_num, $next_num) = @_;
    
    my $min_day = $day - $prev_num;
    my $max_day = $day + $next_num;
    
    my @files;
    my $date = new DateTime::Date(year=>$year, month=>$month);
#    my $min_date = new DateTime::Date(year=>$year, month=>$month, day=>$day);
#    my $max_date = new DateTime::Date(year=>$year, month=>$month, day=>$day);
    
#    $min_date -= $prev_num;
#    $max_date += $next_num;

    # ˤޤ
    if ($min_day < 1){
	my $prev_date = new DateTime::Date(year=>$year, month=>$month, day=>$day);
	$prev_date -= '1M';
	
	my $days_month = $prev_date->DaysMonth;
	@files = $self->pickup_files($prev_date->year,
				   $prev_date->month,
				   $days_month + $min_day,
				   $days_month);
	$min_day = 1;
    }
    push(@files, $self->pickup_files($date->year,
				   $date->month,
				   $min_day, $max_day));
    # ηˤޤ
    if ($max_day > $date->DaysMonth){
	my $next_date = new DateTime::Date(year=>$year, month=>$month, day=>$day);

	my $days_month = $date->DaysMonth;
	$next_date += '1M';
	push(@files, $self->pickup_files($next_date->year,
					 $next_date->month,
					 1,
					 $max_day-$days_month));
    }
    return @files;
}
################################################################
# եѡ
sub parse_file ($$$)
{
#    my ($self, $filename, $year, $month, $day) = @_;
    my ($self, $filename, $parser) = @_;

    # check
    die "BUG: TDS::Collection::parse_file: not TDS::Tdf::Parser object"
	unless ref $parser eq 'TDS::Tdf::Parser';

    open(F, "$filename") || die $filename;
    sub conv;
    *conv = mkjconv($TdfJcode, $TDS::System::InternalJcode);
    while (<F>){
	my $tmp = $_;
	$tmp .= "\n" unless $tmp =~ /\n$/;        # thanks to Mr.Takei
	conv(\$tmp);

	# send to parser
	$parser->Parse($tmp);
    }
    close F;
    return $parser;
}
################################################################
# read specified files.
# return number of read files.
sub read_files($@)
{
    my ($self, @files) = @_;

    require TDS::Cache;
    # clear caches if tdf files is updated
    my $total;
    my $reverse = $ReverseInRecent && $TDS::Status->mode =~ /RECENT/;
    # for all files

    for (@files){
	last unless ref $_;
	my ($filename, $year, $month, $day) = @$_;
	next unless $filename;
	my $cache_unused;

#	warn times, " collect: $filename";
#	print "<br>$year/$month/$day:";
	
	# read from cache if possile
	if ($TDS::Cache::EnableCache){
	    require TDS::Cache::Daily;
	    #warn "read cache: $year/$month/$day";
	    my $cache = new TDS::Cache::Daily(reverse=>$reverse);

	    $cache->year($year);
	    $cache->month($month);
	    $cache->day($day);
	    if ($cache->IsFresh){
#		warn times, " use daily cache: ", $cache->GetCacheFilename;
		push(@{$self->diarys}, $cache);
		$TDS::Status->has_secret(1)
		    if $cache->has_secret;
		$cache_unused = 0;
	    } else {
		$cache_unused = 1;
	    }
	} else {
	    $cache_unused = 1;
	}
#	warn "$year/$month/$day: cache unused $cache_unused";
	# if impossible, read tdf file and parse it
	if ($cache_unused){
#	    warn times, " cannot use daily cache, so parse it";
	    my $date_line = "DIARY $year $month $day\n";
	
#	    my $start = (times)[0];
	    require TDS::Tdf::Parser;
	    my $parser = new TDS::Tdf::Parser;
	    $parser->Parse($date_line);

	    $self->parse_file($filename, $parser);
	    $parser->end('DIARY');

	    push(@{$self->diarys}, $parser);
	}
    }
#    return $_ = @files;                # ActivePerl 613  modification of a read-only value ܤ
#    warn times, "done";
    return scalar(@files);
    
#    push(@{$self->diarys}, $parser);
#    print "<br>read done: ", time() - $TDS::Status->start_time->time;    
}
################################################################
sub AsTdf($)
{
    my $self = shift;
    my $lines;
    
    for (@{$self->diarys}){
	$lines = $_->top->AsTdf;
    }
    return $lines;
}

sub AsHTML($;$)
{
    my ($self, $params) = @_;

    $params->{topic} = $TDS::Status->topic;
    $params->{mode} = $TDS::Status->mode;
#    print "AsHTML...\n";
    my $html;

    # for all diarys
    require TDS::Cache;
    my $cache;
    
    my @htmls;
    my $s = (times)[0];
    for (@{$self->diarys}){
	if (ref $_ eq 'TDS::Tdf::Parser'){
	    my $parser = $_;
	    my $daily_html = $parser->top->AsHTML($params);
	    # auto complete
	    if ($AutoReplace){
		require TDS::Replacer;
		;TDS::Replacer->ReplaceLine(\$daily_html);
	    }
	    if ($TDS::Cache::EnableCache){
		require TDS::Cache::Daily;
		$cache = 
		    new TDS::Cache::Daily('reverse'=>$ReverseInRecent &&
					  $TDS::Status->mode =~ /RECENT/);
		$cache->Set($params->{'year'},
			    $params->{'month'},
			    $params->{'day'});
		if ($params->{'has_secret'}){
		    $cache->has_secret(1);
		    $TDS::Status->has_secret(1);
		}
		# if it has secret part, then do NOT write cache
		# return if $self->is_author && $self->has_secret;
		$cache->WriteCache($daily_html);
	    }
	    $html .= $daily_html;
##	    push(@htmls, $daily_html);
	} elsif (ref $_ eq 'TDS::Cache::Daily'){
#	    $html .= "cached" . ($_->prefix) . ($_->html);
	    $html .= $_->ReadCache;
##	    push(@htmls, $_->html);
	} else {
	    die "BUG: Collection::AsHTML: illegal reference";
	}
    }

    unless ($html){
	$html = $self->NoContentHook;
    }
    my $e = (times)[0];
##    warn times, " col AsHTML elasp: ", $e - $s;
    return $html;
##    return join('', @htmls);
}
sub NoContentHook($)
{
}

1;
