/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.vcf;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.campagnelab.goby.readers.vcf.ColumnField;
import org.campagnelab.goby.readers.vcf.ColumnInfo;

public class GroupAssociations {
    private ObjectArrayList<String> associations;
    private Object2ObjectMap<String, ObjectArraySet<String>> groupToColumns = new Object2ObjectOpenHashMap();

    public boolean hasAssociations() {
        return this.groupToColumns.size() != 0;
    }

    public GroupAssociations(String associationsAsText, ColumnInfo formatColumn, String[] sampleIds) {
        this.associations = this.parse(associationsAsText);
        if (formatColumn != null && sampleIds != null) {
            for (String sample : sampleIds) {
                ObjectIterator<ColumnField> objectIterator = formatColumn.fields.iterator();
                while (objectIterator.hasNext()) {
                    ColumnField formatField = (ColumnField)objectIterator.next();
                    this.associate(String.format("%s[%s]", sample, formatField.id), sample);
                }
            }
        }
    }

    private ObjectArrayList<String> parse(String associationsAsText) {
        ObjectArrayList associations = new ObjectArrayList();
        if (associationsAsText == null) {
            return associations;
        }
        String[] tokens = associationsAsText.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            associations.add((Object)token);
            String[] col_group = token.split("=");
            this.associate(col_group[0], col_group[1]);
        }
        return associations;
    }

    private void associate(String columnName, String group) {
        ObjectArraySet colList = (ObjectArraySet)this.groupToColumns.get((Object)group);
        if (colList == null) {
            colList = new ObjectArraySet();
            this.groupToColumns.put((Object)group, (Object)colList);
        }
        colList.add((Object)columnName);
    }

    public ObjectArraySet<String> getColumnsWithGroup(String group) {
        return (ObjectArraySet)this.groupToColumns.get((Object)group);
    }

    public String listGroupsAsString(String columnName) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String association : this.associations) {
            if (!this.isMatchingColumnName(columnName, association)) continue;
            if (!first) {
                sb.append(",");
            }
            sb.append(association.replace(this.getMatchingString(columnName, association), ""));
            first = false;
        }
        return sb.toString();
    }

    private String getMatchingString(String columnName, String association) {
        if (association.startsWith(columnName)) {
            return columnName + '=';
        }
        if (association.startsWith("INFO/") && association.contains(columnName)) {
            return "INFO/" + columnName + '=';
        }
        String strippedColName = columnName.substring("INFO[".length(), columnName.length() - 1);
        if (association.startsWith("INFO") && association.contains(strippedColName)) {
            return "INFO/" + strippedColName + '=';
        }
        return "not-matchjing=q3p-ow";
    }

    private boolean isMatchingColumnName(String columnName, String association) {
        if (association == null || columnName == null) {
            return false;
        }
        String infoColumn = "INFO/" + columnName + "=";
        if (association.startsWith(columnName) || association.startsWith(infoColumn)) {
            return true;
        }
        String strippedColName = columnName.replace("INFO[", "").replace("]", "");
        return association.startsWith("INFO") && association.contains(strippedColName);
    }

    public ObjectArrayList<String> listGroups(String columnName) {
        ObjectArrayList result = new ObjectArrayList();
        for (String association : this.associations) {
            if (!this.isMatchingColumnName(columnName, association)) continue;
            String matchingString = this.getMatchingString(columnName, association);
            result.add((Object)association.replace(matchingString, ""));
        }
        return result;
    }
}

