require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_SCSIPI_SCSIPICONF_H_)) {
    eval 'sub _DEV_SCSIPI_SCSIPICONF_H_ () {1;}' unless defined(&_DEV_SCSIPI_SCSIPICONF_H_);
    require 'sys/callout.ph';
    require 'sys/queue.ph';
    require 'sys/condvar.ph';
    require 'dev/scsipi/scsi_spc.ph';
    require 'dev/scsipi/scsipi_debug.ph';
    eval("sub ASYNC_EVENT_MAX_OPENINGS () { 0; }") unless defined(&ASYNC_EVENT_MAX_OPENINGS);
    eval("sub ASYNC_EVENT_XFER_MODE () { 1; }") unless defined(&ASYNC_EVENT_XFER_MODE);
    eval("sub ASYNC_EVENT_RESET () { 2; }") unless defined(&ASYNC_EVENT_RESET);
    eval("sub ADAPTER_REQ_RUN_XFER () { 0; }") unless defined(&ADAPTER_REQ_RUN_XFER);
    eval("sub ADAPTER_REQ_GROW_RESOURCES () { 1; }") unless defined(&ADAPTER_REQ_GROW_RESOURCES);
    eval("sub ADAPTER_REQ_SET_XFER_MODE () { 2; }") unless defined(&ADAPTER_REQ_SET_XFER_MODE);
    if(defined(&_KERNEL)) {
	eval 'sub SCSIPI_ADAPT_POLL_ONLY () {0x1;}' unless defined(&SCSIPI_ADAPT_POLL_ONLY);
	eval 'sub SCSIPI_ADAPT_MPSAFE () {0x2;}' unless defined(&SCSIPI_ADAPT_MPSAFE);
    }
    eval 'sub SCSIPI_BUSTYPE_TYPE_SHIFT () {0;}' unless defined(&SCSIPI_BUSTYPE_TYPE_SHIFT);
    eval 'sub SCSIPI_BUSTYPE_TYPE {
        my($x) = @_;
	    eval q(((($x) >>  &SCSIPI_BUSTYPE_TYPE_SHIFT) & 0xff));
    }' unless defined(&SCSIPI_BUSTYPE_TYPE);
    eval 'sub SCSIPI_BUSTYPE_SCSI () {0;}' unless defined(&SCSIPI_BUSTYPE_SCSI);
    eval 'sub SCSIPI_BUSTYPE_ATAPI () {1;}' unless defined(&SCSIPI_BUSTYPE_ATAPI);
    eval 'sub SCSIPI_BUSTYPE_SUBTYPE_SHIFT () {8;}' unless defined(&SCSIPI_BUSTYPE_SUBTYPE_SHIFT);
    eval 'sub SCSIPI_BUSTYPE_SUBTYPE {
        my($x) = @_;
	    eval q(((($x) >>  &SCSIPI_BUSTYPE_SUBTYPE_SHIFT) & 0xff));
    }' unless defined(&SCSIPI_BUSTYPE_SUBTYPE);
    eval 'sub SCSIPI_BUSTYPE_BUSTYPE {
        my($t, $s) = @_;
	    eval q((($t) <<  &SCSIPI_BUSTYPE_TYPE_SHIFT | ($s) <<  &SCSIPI_BUSTYPE_SUBTYPE_SHIFT));
    }' unless defined(&SCSIPI_BUSTYPE_BUSTYPE);
    eval 'sub SCSIPI_CHAN_PERIPH_BUCKETS () {16;}' unless defined(&SCSIPI_CHAN_PERIPH_BUCKETS);
    eval 'sub SCSIPI_CHAN_PERIPH_HASHMASK () {( &SCSIPI_CHAN_PERIPH_BUCKETS - 1);}' unless defined(&SCSIPI_CHAN_PERIPH_HASHMASK);
    if(defined(&_KERNEL)) {
	eval 'sub chan_cv_complete {
	    my($ch) = @_;
    	    eval q((($ch)-> &chan_cv_comp));
	}' unless defined(&chan_cv_complete);
	eval 'sub chan_cv_thread {
	    my($ch) = @_;
    	    eval q((($ch)-> &chan_cv_thr));
	}' unless defined(&chan_cv_thread);
	eval 'sub chan_running {
	    my($ch) = @_;
    	    eval q((($ch)-> ($chan_adapter->{adapt_running})));
	}' unless defined(&chan_running);
	eval 'sub chan_mtx {
	    my($ch) = @_;
    	    eval q((($ch)-> ($chan_adapter->{adapt_mtx})));
	}' unless defined(&chan_mtx);
    }
    eval 'sub SCSIPI_CHAN_OPENINGS () {0x1;}' unless defined(&SCSIPI_CHAN_OPENINGS);
    eval 'sub SCSIPI_CHAN_CANGROW () {0x2;}' unless defined(&SCSIPI_CHAN_CANGROW);
    eval 'sub SCSIPI_CHAN_NOSETTLE () {0x4;}' unless defined(&SCSIPI_CHAN_NOSETTLE);
    eval 'sub SCSIPI_CHAN_TACTIVE () {0x8;}' unless defined(&SCSIPI_CHAN_TACTIVE);
    eval 'sub SCSIPI_CHANT_SHUTDOWN () {0x1;}' unless defined(&SCSIPI_CHANT_SHUTDOWN);
    eval 'sub SCSIPI_CHANT_CALLBACK () {0x2;}' unless defined(&SCSIPI_CHANT_CALLBACK);
    eval 'sub SCSIPI_CHANT_KICK () {0x4;}' unless defined(&SCSIPI_CHANT_KICK);
    eval 'sub SCSIPI_CHANT_GROWRES () {0x8;}' unless defined(&SCSIPI_CHANT_GROWRES);
    eval 'sub SCSIPI_CHAN_MAX_PERIPH {
        my($chan) = @_;
	    eval q(((($chan)-> &chan_flags &  &SCSIPI_CHAN_OPENINGS) ? ($chan)-> &chan_max_periph : ($chan)-> ($chan_adapter->{adapt_max_periph})));
    }' unless defined(&SCSIPI_CHAN_MAX_PERIPH);
    eval 'sub scsipi_printaddr {
        my($periph) = @_;
	    eval q((*($periph)-> ($periph_channel->{chan_bustype}->{bustype_printaddr}))(($periph)));
    }' unless defined(&scsipi_printaddr);
    eval 'sub scsipi_periph_bustype {
        my($periph) = @_;
	    eval q(($periph)-> ($periph_channel->{chan_bustype}->{bustype_type}));
    }' unless defined(&scsipi_periph_bustype);
    eval 'sub PERIPH_NTAGWORDS () {((256/ 8) / $sizeof{ &u_int32_t});}' unless defined(&PERIPH_NTAGWORDS);
    if(defined(&_KERNEL)) {
	eval 'sub SCSIPI_TI_VALID () {0x1;}' unless defined(&SCSIPI_TI_VALID);
	eval 'sub SCSIPI_TI_LOGGED () {0x8000;}' unless defined(&SCSIPI_TI_LOGGED);
	eval 'sub periph_cv_periph {
	    my($p) = @_;
    	    eval q((($p)-> &periph_cv));
	}' unless defined(&periph_cv_periph);
	eval 'sub periph_cv_active {
	    my($p) = @_;
    	    eval q((($p)-> &periph_cv));
	}' unless defined(&periph_cv_active);
    }
    eval 'sub PERIPH_XFER_MODE {
        my($periph) = @_;
	    eval q(((($periph)-> &periph_flags &  &PERIPH_MODE_VALID) ? ($periph)-> &periph_mode : 0));
    }' unless defined(&PERIPH_XFER_MODE);
    eval 'sub PERIPH_CAP_ANEC () {0x1;}' unless defined(&PERIPH_CAP_ANEC);
    eval 'sub PERIPH_CAP_TERMIOP () {0x2;}' unless defined(&PERIPH_CAP_TERMIOP);
    eval 'sub PERIPH_CAP_RELADR () {0x4;}' unless defined(&PERIPH_CAP_RELADR);
    eval 'sub PERIPH_CAP_WIDE32 () {0x8;}' unless defined(&PERIPH_CAP_WIDE32);
    eval 'sub PERIPH_CAP_WIDE16 () {0x10;}' unless defined(&PERIPH_CAP_WIDE16);
    eval 'sub PERIPH_CAP_SYNC () {0x80;}' unless defined(&PERIPH_CAP_SYNC);
    eval 'sub PERIPH_CAP_LINKCMDS () {0x100;}' unless defined(&PERIPH_CAP_LINKCMDS);
    eval 'sub PERIPH_CAP_TQING () {0x200;}' unless defined(&PERIPH_CAP_TQING);
    eval 'sub PERIPH_CAP_SFTRESET () {0x400;}' unless defined(&PERIPH_CAP_SFTRESET);
    eval 'sub PERIPH_CAP_CMD16 () {0x800;}' unless defined(&PERIPH_CAP_CMD16);
    eval 'sub PERIPH_CAP_DT () {0x1000;}' unless defined(&PERIPH_CAP_DT);
    eval 'sub PERIPH_CAP_QAS () {0x2000;}' unless defined(&PERIPH_CAP_QAS);
    eval 'sub PERIPH_CAP_IUS () {0x4000;}' unless defined(&PERIPH_CAP_IUS);
    eval 'sub PERIPH_REMOVABLE () {0x1;}' unless defined(&PERIPH_REMOVABLE);
    eval 'sub PERIPH_MEDIA_LOADED () {0x2;}' unless defined(&PERIPH_MEDIA_LOADED);
    eval 'sub PERIPH_WAITING () {0x4;}' unless defined(&PERIPH_WAITING);
    eval 'sub PERIPH_OPEN () {0x8;}' unless defined(&PERIPH_OPEN);
    eval 'sub PERIPH_WAITDRAIN () {0x10;}' unless defined(&PERIPH_WAITDRAIN);
    eval 'sub PERIPH_GROW_OPENINGS () {0x20;}' unless defined(&PERIPH_GROW_OPENINGS);
    eval 'sub PERIPH_MODE_VALID () {0x40;}' unless defined(&PERIPH_MODE_VALID);
    eval 'sub PERIPH_RECOVERING () {0x80;}' unless defined(&PERIPH_RECOVERING);
    eval 'sub PERIPH_RECOVERY_ACTIVE () {0x100;}' unless defined(&PERIPH_RECOVERY_ACTIVE);
    eval 'sub PERIPH_KEEP_LABEL () {0x200;}' unless defined(&PERIPH_KEEP_LABEL);
    eval 'sub PERIPH_SENSE () {0x400;}' unless defined(&PERIPH_SENSE);
    eval 'sub PERIPH_UNTAG () {0x800;}' unless defined(&PERIPH_UNTAG);
    eval 'sub PQUIRK_AUTOSAVE () {0x1;}' unless defined(&PQUIRK_AUTOSAVE);
    eval 'sub PQUIRK_NOSYNC () {0x2;}' unless defined(&PQUIRK_NOSYNC);
    eval 'sub PQUIRK_NOWIDE () {0x4;}' unless defined(&PQUIRK_NOWIDE);
    eval 'sub PQUIRK_NOTAG () {0x8;}' unless defined(&PQUIRK_NOTAG);
    eval 'sub PQUIRK_NOLUNS () {0x10;}' unless defined(&PQUIRK_NOLUNS);
    eval 'sub PQUIRK_FORCELUNS () {0x20;}' unless defined(&PQUIRK_FORCELUNS);
    eval 'sub PQUIRK_NOMODESENSE () {0x40;}' unless defined(&PQUIRK_NOMODESENSE);
    eval 'sub PQUIRK_NOSYNCCACHE () {0x100;}' unless defined(&PQUIRK_NOSYNCCACHE);
    eval 'sub PQUIRK_LITTLETOC () {0x400;}' unless defined(&PQUIRK_LITTLETOC);
    eval 'sub PQUIRK_NOCAPACITY () {0x800;}' unless defined(&PQUIRK_NOCAPACITY);
    eval 'sub PQUIRK_NOTUR () {0x1000;}' unless defined(&PQUIRK_NOTUR);
    eval 'sub PQUIRK_NODOORLOCK () {0x2000;}' unless defined(&PQUIRK_NODOORLOCK);
    eval 'sub PQUIRK_NOSENSE () {0x4000;}' unless defined(&PQUIRK_NOSENSE);
    eval 'sub PQUIRK_ONLYBIG () {0x8000;}' unless defined(&PQUIRK_ONLYBIG);
    eval 'sub PQUIRK_NOBIGMODESENSE () {0x40000;}' unless defined(&PQUIRK_NOBIGMODESENSE);
    eval 'sub PQUIRK_CAP_SYNC () {0x80000;}' unless defined(&PQUIRK_CAP_SYNC);
    eval 'sub PQUIRK_CAP_WIDE16 () {0x100000;}' unless defined(&PQUIRK_CAP_WIDE16);
    eval 'sub PQUIRK_CAP_NODT () {0x200000;}' unless defined(&PQUIRK_CAP_NODT);
    eval 'sub PQUIRK_START () {0x400000;}' unless defined(&PQUIRK_START);
    eval 'sub PQUIRK_NOFUA () {0x800000;}' unless defined(&PQUIRK_NOFUA);
    eval 'sub PQUIRK_NOREPSUPPOPC () {0x1000000;}' unless defined(&PQUIRK_NOREPSUPPOPC);
    eval 'sub PQUIRK_NOREADDISCINFO () {0x2000000;}' unless defined(&PQUIRK_NOREADDISCINFO);
    eval("sub XS_NOERROR () { 0; }") unless defined(&XS_NOERROR);
    eval("sub XS_SENSE () { 1; }") unless defined(&XS_SENSE);
    eval("sub XS_SHORTSENSE () { 2; }") unless defined(&XS_SHORTSENSE);
    eval("sub XS_DRIVER_STUFFUP () { 3; }") unless defined(&XS_DRIVER_STUFFUP);
    eval("sub XS_RESOURCE_SHORTAGE () { 4; }") unless defined(&XS_RESOURCE_SHORTAGE);
    eval("sub XS_SELTIMEOUT () { 5; }") unless defined(&XS_SELTIMEOUT);
    eval("sub XS_TIMEOUT () { 6; }") unless defined(&XS_TIMEOUT);
    eval("sub XS_BUSY () { 7; }") unless defined(&XS_BUSY);
    eval("sub XS_RESET () { 8; }") unless defined(&XS_RESET);
    eval("sub XS_REQUEUE () { 9; }") unless defined(&XS_REQUEUE);
    if(defined(&_KERNEL)) {
	eval 'sub xs_cv {
	    my($xs) = @_;
    	    eval q((($xs)-> ($xs_periph->{periph_channel}->{chan_cv_xs})));
	}' unless defined(&xs_cv);
    }
    eval 'sub XS_CTL_NOSLEEP () {0x1;}' unless defined(&XS_CTL_NOSLEEP);
    eval 'sub XS_CTL_POLL () {0x2;}' unless defined(&XS_CTL_POLL);
    eval 'sub XS_CTL_DISCOVERY () {0x4;}' unless defined(&XS_CTL_DISCOVERY);
    eval 'sub XS_CTL_ASYNC () {0x8;}' unless defined(&XS_CTL_ASYNC);
    eval 'sub XS_CTL_USERCMD () {0x10;}' unless defined(&XS_CTL_USERCMD);
    eval 'sub XS_CTL_SILENT () {0x20;}' unless defined(&XS_CTL_SILENT);
    eval 'sub XS_CTL_IGNORE_NOT_READY () {0x40;}' unless defined(&XS_CTL_IGNORE_NOT_READY);
    eval 'sub XS_CTL_IGNORE_MEDIA_CHANGE () {0x80;}' unless defined(&XS_CTL_IGNORE_MEDIA_CHANGE);
    eval 'sub XS_CTL_IGNORE_ILLEGAL_REQUEST () {0x100;}' unless defined(&XS_CTL_IGNORE_ILLEGAL_REQUEST);
    eval 'sub XS_CTL_SILENT_NODEV () {0x200;}' unless defined(&XS_CTL_SILENT_NODEV);
    eval 'sub XS_CTL_RESET () {0x400;}' unless defined(&XS_CTL_RESET);
    eval 'sub XS_CTL_DATA_UIO () {0x800;}' unless defined(&XS_CTL_DATA_UIO);
    eval 'sub XS_CTL_DATA_IN () {0x1000;}' unless defined(&XS_CTL_DATA_IN);
    eval 'sub XS_CTL_DATA_OUT () {0x2000;}' unless defined(&XS_CTL_DATA_OUT);
    eval 'sub XS_CTL_TARGET () {0x4000;}' unless defined(&XS_CTL_TARGET);
    eval 'sub XS_CTL_ESCAPE () {0x8000;}' unless defined(&XS_CTL_ESCAPE);
    eval 'sub XS_CTL_URGENT () {0x10000;}' unless defined(&XS_CTL_URGENT);
    eval 'sub XS_CTL_SIMPLE_TAG () {0x20000;}' unless defined(&XS_CTL_SIMPLE_TAG);
    eval 'sub XS_CTL_ORDERED_TAG () {0x40000;}' unless defined(&XS_CTL_ORDERED_TAG);
    eval 'sub XS_CTL_HEAD_TAG () {0x80000;}' unless defined(&XS_CTL_HEAD_TAG);
    eval 'sub XS_CTL_THAW_PERIPH () {0x100000;}' unless defined(&XS_CTL_THAW_PERIPH);
    eval 'sub XS_CTL_FREEZE_PERIPH () {0x200000;}' unless defined(&XS_CTL_FREEZE_PERIPH);
    eval 'sub XS_CTL_REQSENSE () {0x800000;}' unless defined(&XS_CTL_REQSENSE);
    eval 'sub XS_CTL_TAGMASK () {( &XS_CTL_SIMPLE_TAG| &XS_CTL_ORDERED_TAG| &XS_CTL_HEAD_TAG);}' unless defined(&XS_CTL_TAGMASK);
    eval 'sub XS_CTL_TAGTYPE {
        my($xs) = @_;
	    eval q((($xs)-> &xs_control &  &XS_CTL_TAGMASK));
    }' unless defined(&XS_CTL_TAGTYPE);
    eval 'sub XS_STS_DONE () {0x1;}' unless defined(&XS_STS_DONE);
    eval 'sub XS_STS_PRIVATE () {0xf0000000;}' unless defined(&XS_STS_PRIVATE);
    eval 'sub SCSIPIRETRIES () {4;}' unless defined(&SCSIPIRETRIES);
    if(defined(&_KERNEL)) {
    }
    eval 'sub _lto2b {
        my($val,$bytes) = @_;
	    eval q({ $bytes->[0] = ($val >> 8) & 0xff; $bytes->[1] = $val & 0xff; });
    }' unless defined(&_lto2b);
    eval 'sub _lto3b {
        my($val,$bytes) = @_;
	    eval q({ $bytes->[0] = ($val >> 16) & 0xff; $bytes->[1] = ($val >> 8) & 0xff; $bytes->[2] = $val & 0xff; });
    }' unless defined(&_lto3b);
    eval 'sub _lto4b {
        my($val,$bytes) = @_;
	    eval q({ $bytes->[0] = ($val >> 24) & 0xff; $bytes->[1] = ($val >> 16) & 0xff; $bytes->[2] = ($val >> 8) & 0xff; $bytes->[3] = $val & 0xff; });
    }' unless defined(&_lto4b);
    eval 'sub _lto8b {
        my($val,$bytes) = @_;
	    eval q({ $bytes->[0] = ($val >> 56) & 0xff; $bytes->[1] = ($val >> 48) & 0xff; $bytes->[2] = ($val >> 40) & 0xff; $bytes->[3] = ($val >> 32) & 0xff; $bytes->[4] = ($val >> 24) & 0xff; $bytes->[5] = ($val >> 16) & 0xff; $bytes->[6] = ($val >> 8) & 0xff; $bytes->[7] = $val & 0xff; });
    }' unless defined(&_lto8b);
    eval 'sub _2btol {
        my($bytes) = @_;
	    eval q({  &u_int32_t  &rv;  &rv = ($bytes->[0] << 8) | $bytes->[1]; ( &rv); });
    }' unless defined(&_2btol);
    eval 'sub _3btol {
        my($bytes) = @_;
	    eval q({  &u_int32_t  &rv;  &rv = ($bytes->[0] << 16) | ($bytes->[1] << 8) | $bytes->[2]; ( &rv); });
    }' unless defined(&_3btol);
    eval 'sub _4btol {
        my($bytes) = @_;
	    eval q({  &u_int32_t  &rv;  &rv = (( &u_int32_t)$bytes->[0] << 24) | (( &u_int32_t)$bytes->[1] << 16) | (( &u_int32_t)$bytes->[2] << 8) | ( &u_int32_t)$bytes->[3]; ( &rv); });
    }' unless defined(&_4btol);
    eval 'sub _5btol {
        my($bytes) = @_;
	    eval q({  &u_int64_t  &rv;  &rv = (( &u_int64_t)$bytes->[0] << 32) | (( &u_int64_t)$bytes->[1] << 24) | (( &u_int64_t)$bytes->[2] << 16) | (( &u_int64_t)$bytes->[3] << 8) | ( &u_int64_t)$bytes->[4]; ( &rv); });
    }' unless defined(&_5btol);
    eval 'sub _8btol {
        my($bytes) = @_;
	    eval q({  &u_int64_t  &rv;  &rv = (( &u_int64_t)$bytes->[0] << 56) | (( &u_int64_t)$bytes->[1] << 48) | (( &u_int64_t)$bytes->[2] << 40) | (( &u_int64_t)$bytes->[3] << 32) | (( &u_int64_t)$bytes->[4] << 24) | (( &u_int64_t)$bytes->[5] << 16) | (( &u_int64_t)$bytes->[6] << 8) | ( &u_int64_t)$bytes->[7]; ( &rv); });
    }' unless defined(&_8btol);
    eval 'sub _lto2l {
        my($val,$bytes) = @_;
	    eval q({ $bytes->[0] = $val & 0xff; $bytes->[1] = ($val >> 8) & 0xff; });
    }' unless defined(&_lto2l);
    eval 'sub _lto3l {
        my($val,$bytes) = @_;
	    eval q({ $bytes->[0] = $val & 0xff; $bytes->[1] = ($val >> 8) & 0xff; $bytes->[2] = ($val >> 16) & 0xff; });
    }' unless defined(&_lto3l);
    eval 'sub _lto4l {
        my($val,$bytes) = @_;
	    eval q({ $bytes->[0] = $val & 0xff; $bytes->[1] = ($val >> 8) & 0xff; $bytes->[2] = ($val >> 16) & 0xff; $bytes->[3] = ($val >> 24) & 0xff; });
    }' unless defined(&_lto4l);
    eval 'sub _2ltol {
        my($bytes) = @_;
	    eval q({  &u_int32_t  &rv;  &rv = $bytes->[0] | ($bytes->[1] << 8); ( &rv); });
    }' unless defined(&_2ltol);
    eval 'sub _3ltol {
        my($bytes) = @_;
	    eval q({  &u_int32_t  &rv;  &rv = $bytes->[0] | ($bytes->[1] << 8) | ($bytes->[2] << 16); ( &rv); });
    }' unless defined(&_3ltol);
    eval 'sub _4ltol {
        my($bytes) = @_;
	    eval q({  &u_int32_t  &rv;  &rv = ( &u_int32_t)$bytes->[0] | (( &u_int32_t)$bytes->[1] << 8) | (( &u_int32_t)$bytes->[2] << 16) | (( &u_int32_t)$bytes->[3] << 24); ( &rv); });
    }' unless defined(&_4ltol);
}
1;
