require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_WAIT_H_)) {
    eval 'sub _SYS_WAIT_H_ () {1;}' unless defined(&_SYS_WAIT_H_);
    require 'sys/featuretest.ph';
    require 'sys/types.ph';
    require 'sys/sigtypes.ph';
    require 'sys/siginfo.ph';
    require 'sys/idtype.ph';
    if(!( defined(&_XOPEN_SOURCE) || defined(&_NETBSD_SOURCE) ) || defined(&_KERNEL)) {
	eval 'sub _W_INT {
	    my($i) = @_;
    	    eval q(($i));
	}' unless defined(&_W_INT);
    } else {
	eval 'sub _W_INT {
	    my($w) = @_;
    	    eval q((*( &void *)($w)));
	}' unless defined(&_W_INT);
    }
    eval 'sub _WSTATUS {
        my($x) = @_;
	    eval q(( &_W_INT($x) & 0177));
    }' unless defined(&_WSTATUS);
    eval 'sub _WSTOPPED () {0177;}' unless defined(&_WSTOPPED);
    eval 'sub _WCONTINUED () {0xffff;}' unless defined(&_WCONTINUED);
    eval 'sub WIFSTOPPED {
        my($x) = @_;
	    eval q(( &_WSTATUS($x) ==  &_WSTOPPED  && ! &WIFCONTINUED($x)));
    }' unless defined(&WIFSTOPPED);
    eval 'sub WIFCONTINUED {
        my($x) = @_;
	    eval q(( &_W_INT($x) ==  &_WCONTINUED));
    }' unless defined(&WIFCONTINUED);
    eval 'sub WSTOPSIG {
        my($x) = @_;
	    eval q(((( &_W_INT($x)) >> 8) & 0xff));
    }' unless defined(&WSTOPSIG);
    eval 'sub WIFSIGNALED {
        my($x) = @_;
	    eval q((! &WIFSTOPPED($x)  && ! &WIFCONTINUED($x)  && ! &WIFEXITED($x)));
    }' unless defined(&WIFSIGNALED);
    eval 'sub WTERMSIG {
        my($x) = @_;
	    eval q(( &_WSTATUS($x)));
    }' unless defined(&WTERMSIG);
    eval 'sub WIFEXITED {
        my($x) = @_;
	    eval q(( &_WSTATUS($x) == 0));
    }' unless defined(&WIFEXITED);
    eval 'sub WEXITSTATUS {
        my($x) = @_;
	    eval q(((( &_W_INT($x)) >> 8) & 0xff));
    }' unless defined(&WEXITSTATUS);
    if(defined(&_XOPEN_SOURCE) || defined(&_NETBSD_SOURCE) || defined(&_KERNEL)) {
	eval 'sub WCOREFLAG () {0200;}' unless defined(&WCOREFLAG);
	eval 'sub WCOREDUMP {
	    my($x) = @_;
    	    eval q(( &_W_INT($x) &  &WCOREFLAG));
	}' unless defined(&WCOREDUMP);
	eval 'sub W_EXITCODE {
	    my($ret, $sig) = @_;
    	    eval q((($ret) << 8| ($sig)));
	}' unless defined(&W_EXITCODE);
	eval 'sub W_STOPCODE {
	    my($sig) = @_;
    	    eval q((($sig) << 8|  &_WSTOPPED));
	}' unless defined(&W_STOPCODE);
	eval 'sub W_CONTCODE () {
	    eval q(( &_WCONTINUED));
	}' unless defined(&W_CONTCODE);
    }
    eval 'sub WNOHANG () {0x1;}' unless defined(&WNOHANG);
    eval 'sub WSTOPPED () {0x2;}' unless defined(&WSTOPPED);
    eval 'sub WUNTRACED () { &WSTOPPED;}' unless defined(&WUNTRACED);
    eval 'sub WCONTINUED () {0x10;}' unless defined(&WCONTINUED);
    eval 'sub WEXITED () {0x20;}' unless defined(&WEXITED);
    eval 'sub WNOWAIT () {0x10000;}' unless defined(&WNOWAIT);
    if(defined(&_NETBSD_SOURCE)) {
	eval 'sub WALTSIG () {0x4;}' unless defined(&WALTSIG);
	eval 'sub WALLSIG () {0x8;}' unless defined(&WALLSIG);
	eval 'sub WTRAPPED () {0x40;}' unless defined(&WTRAPPED);
	eval 'sub WNOZOMBIE () {0x20000;}' unless defined(&WNOZOMBIE);
	eval 'sub __WCLONE () { &WALTSIG;}' unless defined(&__WCLONE);
	eval 'sub __WALL () { &WALLSIG;}' unless defined(&__WALL);
    }
    if(defined(&_KERNEL)) {
	eval 'sub WSELECTOPTS () {( &WEXITED| &WUNTRACED| &WCONTINUED| &WTRAPPED);}' unless defined(&WSELECTOPTS);
	eval 'sub WALLOPTS () {( &WNOHANG| &WALTSIG| &WALLSIG| &WNOWAIT| &WNOZOMBIE| &WSELECTOPTS);}' unless defined(&WALLOPTS);
    }
    if(defined(&_NETBSD_SOURCE) || defined(&_XOPEN_SOURCE)) {
	eval 'sub WAIT_ANY () {(-1);}' unless defined(&WAIT_ANY);
	eval 'sub WAIT_MYPGRP () {0;}' unless defined(&WAIT_MYPGRP);
	require 'sys/types.ph';
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	}
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
	}
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	}
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
	}
	eval 'sub w_termsig () { ($w_T->{w_Termsig});}' unless defined(&w_termsig);
	eval 'sub w_coredump () { ($w_T->{w_Coredump});}' unless defined(&w_coredump);
	eval 'sub w_retcode () { ($w_T->{w_Retcode});}' unless defined(&w_retcode);
	eval 'sub w_stopval () { ($w_S->{w_Stopval});}' unless defined(&w_stopval);
	eval 'sub w_stopsig () { ($w_S->{w_Stopsig});}' unless defined(&w_stopsig);
    }
    unless(defined(&_KERNEL)) {
	require 'sys/cdefs.ph';
	if(defined(&_XOPEN_SOURCE) || defined(&_NETBSD_SOURCE)) {
	    unless(defined(&__LIBC12_SOURCE__)) {
	    }
	}
    }
}
1;
