/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    public static final Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        URL u = Naming.parseURL(name);
        String serviceName = Naming.getName(u);
        return Naming.getRegistry(u).lookup(serviceName);
    }

    public static final void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        URL u = Naming.parseURL(name);
        String serviceName = Naming.getName(u);
        Naming.getRegistry(u).bind(serviceName, obj);
    }

    public static final void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        URL u = Naming.parseURL(name);
        String serviceName = Naming.getName(u);
        Naming.getRegistry(u).unbind(serviceName);
    }

    public static final void rebind(String name, Remote obj) throws RemoteException, MalformedURLException {
        URL u = Naming.parseURL(name);
        String serviceName = Naming.getName(u);
        Naming.getRegistry(u).rebind(serviceName, obj);
    }

    public static final String[] list(String name) throws RemoteException, MalformedURLException {
        return Naming.getRegistry(Naming.parseURL(name)).list();
    }

    private static final Registry getRegistry(URL u) throws RemoteException {
        if (u.getPort() == -1) {
            return LocateRegistry.getRegistry(u.getHost());
        }
        return LocateRegistry.getRegistry(u.getHost(), u.getPort());
    }

    private static final URL parseURL(String name) throws MalformedURLException {
        try {
            URI uri = new URI(name);
            String host = uri.getHost();
            int port = uri.getPort();
            String query = uri.getQuery();
            String path = uri.getPath();
            return new URL("http", host == null ? "localhost" : host, port == -1 ? 1099 : port, uri.getPath() + (query == null ? "" : query));
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("The URL syntax was invalid: " + e.getMessage());
        }
    }

    private static final String getName(URL url) throws MalformedURLException {
        String filename = url.getFile();
        if (filename.length() == 0) {
            throw new MalformedURLException("No path specified: " + url);
        }
        if (filename.charAt(0) == '/') {
            return filename.substring(1);
        }
        return filename;
    }

    private Naming() {
    }
}

