/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;

public class OverclippedReadFilter
implements SamRecordFilter {
    private final int unclippedBasesThreshold;
    private final boolean filterSingleEndClips;

    public OverclippedReadFilter(int unclippedBasesThreshold, boolean filterSingleEndClips) {
        if (unclippedBasesThreshold < 0) {
            throw new SAMException("unclippedBasesThreshold must be non-negative");
        }
        this.unclippedBasesThreshold = unclippedBasesThreshold;
        this.filterSingleEndClips = filterSingleEndClips;
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        int alignedLength = 0;
        int softClipBlocks = 0;
        int minSoftClipBlocks = this.filterSingleEndClips ? 1 : 2;
        CigarOperator lastOperator = null;
        for (CigarElement element : record.getCigar().getCigarElements()) {
            if (element.getOperator() == CigarOperator.S) {
                if (lastOperator != CigarOperator.S) {
                    ++softClipBlocks;
                }
            } else if (element.getOperator().consumesReadBases()) {
                alignedLength += element.getLength();
            }
            lastOperator = element.getOperator();
        }
        return alignedLength < this.unclippedBasesThreshold && softClipBlocks >= minSoftClipBlocks;
    }

    @Override
    public boolean filterOut(SAMRecord first, SAMRecord second) {
        return this.filterOut(first) || this.filterOut(second);
    }
}

