/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MetalToolTipUI
extends BasicToolTipUI {
    public static final int padSpaceBetweenStrings = 12;
    private static MetalToolTipUI instance = null;
    private boolean isAcceleratorHidden;
    private String acceleratorString;
    private String acceleratorDelimiter;
    private Font acceleratorFont;
    private Color acceleratorForeground;
    private Border activeBorder;
    private Border inactiveBorder;

    public static ComponentUI createUI(JComponent component) {
        if (instance == null) {
            instance = new MetalToolTipUI();
        }
        return instance;
    }

    public String getAcceleratorString() {
        return this.acceleratorString;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Border existingBorder = c.getBorder();
        if (existingBorder == null || existingBorder instanceof UIResource) {
            if (c.isEnabled()) {
                c.setBorder(this.activeBorder);
            } else {
                c.setBorder(this.inactiveBorder);
            }
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (c.getBorder() instanceof UIResource) {
            c.setBorder(null);
        }
    }

    protected boolean isAcceleratorHidden() {
        return this.isAcceleratorHidden;
    }

    public Dimension getPreferredSize(JComponent c) {
        if (this.isAcceleratorHidden()) {
            return super.getPreferredSize(c);
        }
        Insets insets = c.getInsets();
        JToolTip tt = (JToolTip)c;
        String tipText = tt.getTipText();
        if (tipText != null) {
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int prefH = fm.getHeight() + insets.top + insets.bottom;
            int prefW = fm.stringWidth(tipText) + insets.left + insets.right;
            this.acceleratorString = this.fetchAcceleratorString(c);
            if (this.acceleratorString != null) {
                prefW += 12;
                fm = c.getFontMetrics(this.acceleratorFont);
                prefW += fm.stringWidth(this.acceleratorString);
            }
            return new Dimension(prefW, prefH);
        }
        return new Dimension(0, 0);
    }

    public void paint(Graphics g, JComponent c) {
        JToolTip tip = (JToolTip)c;
        String text = tip.getTipText();
        Toolkit t = tip.getToolkit();
        if (text == null) {
            return;
        }
        Rectangle vr = new Rectangle();
        vr = SwingUtilities.calculateInnerArea(tip, vr);
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        FontMetrics fm = t.getFontMetrics(tip.getFont());
        int ascent = fm.getAscent();
        SwingUtilities.layoutCompoundLabel(tip, fm, text, null, 0, 2, 0, 0, vr, ir, tr, 0);
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawString(text, vr.x, vr.y + ascent);
        if (this.acceleratorString != null) {
            g.setFont(this.acceleratorFont);
            g.setColor(this.acceleratorForeground);
            fm = t.getFontMetrics(this.acceleratorFont);
            int width = fm.stringWidth(this.acceleratorString);
            g.drawString(this.acceleratorString, vr.x + vr.width - width - 6, vr.y + vr.height - fm.getDescent());
        }
        g.setColor(saved);
    }

    private final String fetchAcceleratorString(JComponent c) {
        String result = null;
        if (c instanceof JToolTip) {
            JToolTip toolTip = (JToolTip)c;
            JComponent component = toolTip.getComponent();
            KeyStroke ks = null;
            int mne = 0;
            if (component instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)component;
                ks = item.getAccelerator();
                if (ks == null) {
                    mne = item.getMnemonic();
                }
            } else if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                mne = button.getMnemonic();
            }
            if (mne > 0) {
                ks = KeyStroke.getKeyStroke(Character.toUpperCase((char)mne), 8, false);
            }
            if (ks != null) {
                result = this.acceleratorToString(ks);
            }
        }
        return result;
    }

    private final String acceleratorToString(KeyStroke accelerator) {
        String modifiersText = "";
        int modifiers = accelerator.getModifiers();
        char keyChar = accelerator.getKeyChar();
        int keyCode = accelerator.getKeyCode();
        if (modifiers != 0) {
            modifiersText = KeyEvent.getKeyModifiersText(modifiers) + this.acceleratorDelimiter;
        }
        if (keyCode == 0) {
            return modifiersText + keyChar;
        }
        return modifiersText + KeyEvent.getKeyText(keyCode);
    }

    public MetalToolTipUI() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.activeBorder = defaults.getBorder("ToolTip.border");
        this.inactiveBorder = defaults.getBorder("ToolTip.borderInactive");
        this.isAcceleratorHidden = defaults.getBoolean("ToolTip.hideAccelerator");
        this.acceleratorFont = defaults.getFont("MenuItem.acceleratorFont");
        this.acceleratorForeground = defaults.getColor("MenuItem.acceleratorForeground");
        this.acceleratorDelimiter = defaults.getString("MenuItem.acceleratorDelimiter");
    }
}

