/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.log4j.Logger;
import org.broad.igv.batch.BatchRunner;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;

public class RunScriptMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadFilesMenuAction.class);
    IGV igv;

    public RunScriptMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File script;
        if (e.getActionCommand().equalsIgnoreCase("run batch script...") && (script = this.chooseScriptFile()) != null && script.isFile()) {
            BatchRunner bRun = new BatchRunner(script.getPath(), this.igv);
            bRun.run();
        }
    }

    private File chooseScriptFile() {
        File lastDirectoryFile = PreferencesManager.getPreferences().getLastTrackDirectory();
        File scriptFile = FileDialogUtils.chooseFile("Select Script", lastDirectoryFile, 0);
        if (scriptFile != null) {
            PreferencesManager.getPreferences().setLastTrackDirectory(scriptFile.getParentFile());
        }
        this.igv.resetStatusMessage();
        return scriptFile;
    }
}

