/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.lang;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;

public class EnumStringParser<E extends Enum<E>>
extends StringParser {
    private final Class<E> enumClass;
    private final boolean toUpper;

    public E parse(String s) throws ParseException {
        try {
            return (E)((Enum)this.enumClass.getMethod("valueOf", String.class).invoke(null, this.toUpper ? s.toUpperCase() : s));
        }
        catch (Exception e) {
            throw new ParseException("Unknown value '" + s + "'.", (Throwable)e);
        }
    }

    private EnumStringParser(Class<E> enumClass, boolean toUpper) {
        this.enumClass = enumClass;
        this.toUpper = toUpper;
    }

    public static <E extends Enum<E>> EnumStringParser<E> getParser(Class<E> enumClass, boolean toUpper) throws IllegalArgumentException {
        return new EnumStringParser<E>(enumClass, toUpper);
    }

    public static <E extends Enum<E>> EnumStringParser<E> getParser(Class<E> enumClass) throws IllegalArgumentException {
        return EnumStringParser.getParser(enumClass, false);
    }
}

